package example.model;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.lang.Object;
import java.lang.String;
import java.util.Date;
import java.util.Map;

@JsonTypeInfo(
    use = JsonTypeInfo.Id.NAME,
    include = JsonTypeInfo.As.PROPERTY,
    property = "humanType"
)
@JsonSubTypes({
    @JsonSubTypes.Type(example.model.Corpse.class),
    @JsonSubTypes.Type(example.model.Person.class)
})
public interface Human {
  Map<String, Object> getAdditionalProperties();

  void setAdditionalProperties(Map<String, Object> additionalProperties);

  String getHumanType();

  Limb getLimbs();

  void setLimbs(Limb limbs);

  Date getTimeOfArrival();

  void setTimeOfArrival(Date timeOfArrival);

  Date getTimeOfBirth();

  void setTimeOfBirth(Date timeOfBirth);

  Date getDateOfBirth();

  void setDateOfBirth(Date dateOfBirth);

  Date getInstantOfBirth();

  void setInstantOfBirth(Date instantOfBirth);

  Date getRequestTime();

  void setRequestTime(Date requestTime);

  Gender getGender();

  void setGender(Gender gender);
}
