package example.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.lang.Object;
import java.lang.String;
import java.util.Date;
import java.util.List;
import java.util.Map;

@JsonTypeName("person")
@JsonDeserialize(
    as = example.model.PersonImpl.class
)
public interface Person extends Human {
  Map<String, Object> getAdditionalProperties();

  void setAdditionalProperties(Map<String, Object> additionalProperties);

  String getHumanType();

  Limb getLimbs();

  void setLimbs(Limb limbs);

  Date getTimeOfArrival();

  void setTimeOfArrival(Date timeOfArrival);

  Date getTimeOfBirth();

  void setTimeOfBirth(Date timeOfBirth);

  Date getDateOfBirth();

  void setDateOfBirth(Date dateOfBirth);

  Date getInstantOfBirth();

  void setInstantOfBirth(Date instantOfBirth);

  Date getRequestTime();

  void setRequestTime(Date requestTime);

  Gender getGender();

  void setGender(Gender gender);

  String getName();

  void setName(String name);

  int getWeight();

  void setWeight(int weight);

  List<Human> getSiblings();

  void setSiblings(List<Human> siblings);
}
