/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.List;
import org.raml.api.RamlApi;
import org.raml.api.RamlHeaderParameter;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlQueryParameter;
import org.raml.api.RamlResource;
import org.raml.api.RamlResourceMethod;
import org.raml.api.RamlTypes;
import org.raml.emitter.Emitter;
import org.raml.emitter.RamlEmissionException;
import org.raml.utilities.IndentedAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndentedAppendableEmitter
implements Emitter {
    private static final Logger logger = LoggerFactory.getLogger(IndentedAppendableEmitter.class);
    private final IndentedAppendable writer;

    private IndentedAppendableEmitter(IndentedAppendable writer) {
        this.writer = writer;
    }

    public static IndentedAppendableEmitter create(IndentedAppendable appendable) {
        Preconditions.checkNotNull((Object)appendable);
        return new IndentedAppendableEmitter(appendable);
    }

    @Override
    public void emit(RamlApi api) throws RamlEmissionException {
        try {
            this.writeApi(api);
        }
        catch (IOException e) {
            throw new RamlEmissionException(String.format("unable to emit api: %s", api), e);
        }
    }

    private void writeApi(RamlApi api) throws IOException {
        this.writeHeader();
        this.writeTitle(api.getTitle());
        this.writeVersion(api.getVersion());
        this.writeBaseUri(api.getBaseUri());
        this.writeDefaultMediaType(api.getDefaultMediaType());
        for (RamlResource resource : api.getResources()) {
            this.writeResource(resource);
        }
    }

    private void writeDefaultMediaType(RamlMediaType defaultMediaType) throws IOException {
        this.writer.appendLine(String.format("mediaType: %s", defaultMediaType.toStringRepresentation()));
    }

    private void writeResource(RamlResource resource) throws IOException {
        this.writer.appendLine(String.format("%s:", resource.getPath()));
        this.writer.indent();
        for (RamlResourceMethod method : resource.getMethods()) {
            this.writeMethod(method);
        }
        for (RamlResource child : resource.getChildren()) {
            this.writeResource(child);
        }
        this.writer.outdent();
    }

    private void writeMethod(RamlResourceMethod method) throws IOException {
        this.writer.appendLine(String.format("%s:", method.getHttpMethod()));
        this.writer.indent();
        Optional description = method.getDescription();
        if (description.isPresent()) {
            this.writeDescription((String)description.get());
        }
        if (!method.getConsumedMediaTypes().isEmpty()) {
            this.writeBody(method.getConsumedMediaTypes());
        }
        if (!method.getProducedMediaTypes().isEmpty()) {
            this.writeResponses(method.getProducedMediaTypes());
        }
        if (!method.getHeaderParameters().isEmpty()) {
            this.writeHeaderParameters(method.getHeaderParameters());
        }
        if (!method.getQueryParameters().isEmpty()) {
            this.writeQueryParameters(method.getQueryParameters());
        }
        this.writer.outdent();
    }

    private void writeDescription(String description) throws IOException {
        this.writer.appendLine(String.format("description: %s", description));
    }

    private void writeHeaderParameters(Iterable<RamlHeaderParameter> headerParameters) throws IOException {
        this.writer.appendLine("headers:");
        this.writer.indent();
        for (RamlHeaderParameter parameter : headerParameters) {
            this.writeHeaderParameter(parameter);
        }
        this.writer.outdent();
    }

    private void writeHeaderParameter(RamlHeaderParameter parameter) throws IOException {
        this.writer.appendLine(String.format("%s:", parameter.getName()));
        this.writer.indent();
        this.writer.appendLine(String.format("type: %s", RamlTypes.fromType((Type)parameter.getType()).getRamlSyntax()));
        Optional defaultValue = parameter.getDefaultValue();
        if (defaultValue.isPresent()) {
            this.writer.appendLine(String.format("default: %s", defaultValue.get()));
            this.writer.appendLine("required: false");
        }
        this.writer.outdent();
    }

    private void writeQueryParameters(Iterable<RamlQueryParameter> queryParameters) throws IOException {
        this.writer.appendLine("queryParameters:");
        this.writer.indent();
        for (RamlQueryParameter queryParameter : queryParameters) {
            this.writeQueryParameter(queryParameter);
        }
        this.writer.outdent();
    }

    private void writeQueryParameter(RamlQueryParameter queryParameter) throws IOException {
        this.writer.appendLine(String.format("%s:", queryParameter.getName()));
        this.writer.indent();
        this.writer.appendLine(String.format("type: %s", RamlTypes.fromType((Type)queryParameter.getType()).getRamlSyntax()));
        Optional defaultValue = queryParameter.getDefaultValue();
        if (defaultValue.isPresent()) {
            this.writer.appendLine(String.format("default: %s", defaultValue.get()));
            this.writer.appendLine("required: false");
        }
        this.writer.outdent();
    }

    private void writeResponses(List<RamlMediaType> producedMediaTypes) throws IOException {
        this.writer.appendLine("responses:");
        this.writer.indent();
        this.writer.appendLine("200:");
        this.writer.indent();
        this.writeBody(producedMediaTypes);
        this.writer.outdent();
        this.writer.outdent();
    }

    private void writeBody(List<RamlMediaType> mediaTypes) throws IOException {
        this.writer.appendLine("body:");
        this.writer.indent();
        for (RamlMediaType mediaType : mediaTypes) {
            this.writer.appendLine(String.format("%s:", mediaType.toStringRepresentation()));
        }
        this.writer.outdent();
    }

    private void writeHeader() throws IOException {
        this.writer.appendLine("#%RAML 1.0");
    }

    private void writeTitle(String title) throws IOException {
        this.writer.appendLine(String.format("title: %s", title));
    }

    private void writeVersion(String version) throws IOException {
        this.writer.appendLine(String.format("version: %s", version));
    }

    private void writeBaseUri(String baseUri) throws IOException {
        this.writer.appendLine(String.format("baseUri: %s", baseUri));
    }
}

