/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import org.raml.api.RamlApi;
import org.raml.emitter.Emitter;
import org.raml.emitter.IndentedAppendableEmitter;
import org.raml.emitter.RamlEmissionException;
import org.raml.utilities.IndentedAppendable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileEmitter
implements Emitter {
    private static final Logger logger = LoggerFactory.getLogger(FileEmitter.class);
    private final Path filePath;

    private FileEmitter(Path filePath) {
        this.filePath = filePath;
    }

    public static FileEmitter forFile(Path pathToFile) {
        Preconditions.checkNotNull((Object)pathToFile);
        return new FileEmitter(pathToFile);
    }

    @Override
    public void emit(RamlApi api) throws RamlEmissionException {
        if (Files.isRegularFile(this.filePath, new LinkOption[0])) {
            logger.warn("output file {} already exists, will be overwritten", (Object)this.filePath);
        }
        try (PrintWriter writer = FileEmitter.printWriterOf(this.filePath);){
            IndentedAppendable appendable = IndentedAppendable.forNoSpaces((int)4, (Appendable)writer);
            IndentedAppendableEmitter innerEmitter = IndentedAppendableEmitter.create(appendable);
            innerEmitter.emit(api);
        }
        catch (IOException | RamlEmissionException e) {
            throw new RamlEmissionException(String.format("unable to successfully output raml to %s", this.filePath), e);
        }
    }

    private static PrintWriter printWriterOf(Path path) throws IOException {
        return new PrintWriter(Files.newBufferedWriter(path, StandardCharsets.UTF_8, new OpenOption[0]));
    }
}

