/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import org.raml.api.Annotable;
import org.raml.api.RamlResourceMethod;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.utilities.IndentedAppendable;

public class AnnotationInstanceEmitter
implements LocalEmitter {
    private final IndentedAppendable writer;
    private final List<RamlSupportedAnnotation> suportedAnnotations;

    public AnnotationInstanceEmitter(IndentedAppendable writer, List<RamlSupportedAnnotation> supportedAnnotation) {
        this.writer = writer;
        this.suportedAnnotations = supportedAnnotation;
    }

    @Override
    public void emit(RamlType ramlType) throws IOException {
        this.annotate(ramlType);
    }

    @Override
    public void emit(RamlProperty ramlProperty) throws IOException {
        this.annotate(ramlProperty);
    }

    @Override
    public void emit(RamlResourceMethod method) throws IOException {
        this.annotate((Annotable)method);
    }

    private void annotate(Annotable annotable) throws IOException {
        for (RamlSupportedAnnotation suportedAnnotation : this.suportedAnnotations) {
            Optional annotationOptional = suportedAnnotation.getAnnotationInstance(annotable);
            if (!annotationOptional.isPresent()) continue;
            Annotation annotation = (Annotation)annotationOptional.get();
            if (annotation.annotationType().getDeclaredMethods().length == 0) {
                this.writer.appendLine("(" + annotation.annotationType().getSimpleName() + "):");
                continue;
            }
            this.writer.appendLine("(" + annotation.annotationType().getSimpleName() + "):");
            this.writer.indent();
            try {
                for (Method method : annotation.annotationType().getDeclaredMethods()) {
                    Object value = method.invoke((Object)annotation, new Object[0]);
                    if (value.getClass().isArray()) {
                        ArrayList<Object> list = new ArrayList<Object>();
                        for (int i = 0; i < Array.getLength(value); ++i) {
                            list.add(Array.get(value, i));
                        }
                        String listString = Joiner.on((String)", ").join((Iterable)FluentIterable.from(list).transform((Function)new Function<Object, String>(){

                            public String apply(Object input) {
                                return AnnotationInstanceEmitter.this.toValue(input);
                            }
                        }));
                        this.writer.appendLine(method.getName() + ": [" + listString + "]");
                        continue;
                    }
                    this.writer.appendLine(method.getName() + ": " + this.toValue(value));
                }
                this.writer.outdent();
            }
            catch (Exception e) {
                throw new IOException("unable to write property", e);
            }
        }
    }

    private String toValue(Object value) {
        if (Class.class.isAssignableFrom(value.getClass())) {
            return ((Class)value).getSimpleName();
        }
        return value.toString();
    }
}

