/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Optional;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.raml.api.RamlSupportedAnnotation;
import org.raml.api.ScalarType;
import org.raml.utilities.IndentedAppendable;

public class AnnotationTypeEmitter {
    private final IndentedAppendable writer;
    private final List<RamlSupportedAnnotation> suportedAnnotations;

    public AnnotationTypeEmitter(IndentedAppendable writer, List<RamlSupportedAnnotation> supportedAnnotation) {
        this.writer = writer;
        this.suportedAnnotations = supportedAnnotation;
    }

    public void emitAnnotations() throws IOException {
        this.writer.appendLine("annotationTypes:");
        this.writer.indent();
        for (RamlSupportedAnnotation ramlSupportedAnnotation : this.suportedAnnotations) {
            Class javaAnnotation = ramlSupportedAnnotation.getAnnotation();
            if (javaAnnotation.getDeclaredMethods().length > 0) {
                this.writer.appendLine(javaAnnotation.getSimpleName() + ":");
                this.writer.indent();
                this.writer.appendLine("properties:");
                this.writer.indent();
                for (Method method : javaAnnotation.getDeclaredMethods()) {
                    if (method.getReturnType().isArray()) {
                        this.writer.appendLine(method.getName() + ": " + this.calculateRamlType(method.getReturnType().getComponentType()) + "[]");
                        continue;
                    }
                    this.writer.appendLine(method.getName() + ": " + this.calculateRamlType(method.getReturnType()));
                }
                this.writer.outdent();
                this.writer.outdent();
                continue;
            }
            this.writer.appendLine(javaAnnotation.getSimpleName() + ": nil");
        }
        this.writer.outdent();
    }

    public String calculateRamlType(Class<?> type) throws IOException {
        if (Class.class.equals(type)) {
            return "string";
        }
        Optional scalarType = ScalarType.fromType(type);
        if (scalarType.isPresent()) {
            return ((ScalarType)scalarType.get()).getRamlSyntax();
        }
        throw new IOException("invalid type for annotation: " + type);
    }
}

