/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import com.google.common.base.Optional;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.common.Example;
import org.raml.jaxrs.common.ExampleCases;
import org.raml.jaxrs.common.Examples;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.utilities.IndentedAppendable;

public class ExampleEmitter
implements LocalEmitter {
    private final IndentedAppendable writer;
    private boolean headerDone = false;
    private String currentCaseName;
    private Set<String> seenTypeNames = new HashSet<String>();

    public ExampleEmitter(IndentedAppendable writer) {
        this.writer = writer;
    }

    @Override
    public void emit(RamlType ramlType) throws IOException {
        if (this.seenTypeNames.contains(ramlType.getTypeName())) {
            return;
        }
        this.seenTypeNames.add(ramlType.getTypeName());
        if (!this.headerDone) {
            Optional<ExampleCases> examplesAnnotation = ramlType.getAnnotation(ExampleCases.class);
            if (examplesAnnotation.isPresent()) {
                String[] examples = ((ExampleCases)examplesAnnotation.get()).value();
                this.writer.appendLine("examples:");
                for (String caseName : examples) {
                    if (caseName.isEmpty()) {
                        throw new IOException("@ExampleCases case on type " + ramlType.getTypeName() + " is empty");
                    }
                    this.currentCaseName = caseName;
                    this.writer.indent();
                    this.writer.appendLine(caseName + ":");
                    this.writer.indent();
                    this.writer.appendLine("strict: false");
                    this.writer.appendLine("value:");
                    this.writer.indent();
                    if (this.hasAnExample(ramlType)) {
                        this.emitOneExample(ramlType);
                    }
                    this.writer.outdent();
                    this.writer.outdent();
                    this.writer.outdent();
                }
            } else {
                this.currentCaseName = "";
                if (!this.hasAnExample(ramlType)) {
                    return;
                }
                boolean currentHeaderDone = this.headerDone;
                this.writer.appendLine("example:");
                this.writer.indent();
                this.writer.appendLine("strict: false");
                this.writer.appendLine("value:");
                this.writer.indent();
                this.headerDone = true;
                this.emitOneExample(ramlType);
                if (!currentHeaderDone) {
                    this.writer.outdent();
                    this.writer.outdent();
                }
            }
        } else {
            this.emitOneExample(ramlType);
        }
    }

    private void emitOneExample(RamlType ramlType) throws IOException {
        for (RamlProperty ramlProperty : ramlType.getProperties()) {
            ramlProperty.emit(this);
        }
    }

    @Override
    public void emit(RamlProperty ramlProperty) throws IOException {
        RamlType ramlType = ramlProperty.getRamlType();
        if (!ramlType.isRamlScalarType()) {
            this.writer.appendLine(ramlProperty.getName() + ":");
            this.writer.indent();
            ramlType.emit(this);
            this.writer.outdent();
        } else {
            Optional<Example> e = ramlProperty.getAnnotation(Example.class);
            if (e.isPresent() && ((Example)e.get()).useCase().equals(this.currentCaseName)) {
                this.writer.appendLine(ramlProperty.getName() + ": " + ((Example)e.get()).value());
                return;
            }
            Optional<Examples> examplesAnnotation = ramlProperty.getAnnotation(Examples.class);
            if (examplesAnnotation.isPresent()) {
                for (Example example : ((Examples)examplesAnnotation.get()).value()) {
                    if (!example.useCase().equals(this.currentCaseName)) continue;
                    this.writer.appendLine(ramlProperty.getName() + ": " + example.value());
                    return;
                }
            }
        }
    }

    private boolean hasAnExample(RamlType type) {
        for (RamlProperty ramlProperty : type.getProperties()) {
            Optional<Example> annotation = ramlProperty.getAnnotation(Example.class);
            if (annotation.isPresent()) {
                return ((Example)annotation.get()).useCase().equals(this.currentCaseName);
            }
            Optional<Examples> examplesAnnotation = ramlProperty.getAnnotation(Examples.class);
            if (!examplesAnnotation.isPresent()) continue;
            for (Example example : ((Examples)examplesAnnotation.get()).value()) {
                if (!example.useCase().equals(this.currentCaseName)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void emit(RamlResourceMethod method) throws IOException {
    }
}

