/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.emitters;

import java.io.IOException;
import java.lang.reflect.Type;
import javax.validation.constraints.Max;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import org.raml.api.RamlParameter;
import org.raml.api.RamlType;
import org.raml.api.RamlTypes;
import org.raml.api.ScalarType;
import org.raml.utilities.IndentedAppendable;

public class ParameterEmitter {
    private IndentedAppendable writer;

    public ParameterEmitter(IndentedAppendable writer) {
        this.writer = writer;
    }

    public void emit(RamlParameter parameter) throws IOException {
        this.writer.appendLine(String.format("%s:", parameter.getName()));
        this.writer.indent();
        RamlType ramlType = RamlTypes.fromType((Type)parameter.getType());
        this.writer.appendLine("type", ramlType.getRamlSyntax());
        if (parameter.getDefaultValue().isPresent()) {
            this.writer.appendEscapedLine("default", (String)parameter.getDefaultValue().get());
            this.writer.appendLine("required", "false");
        } else if (parameter.getAnnotation(NotNull.class).isPresent()) {
            this.writer.appendLine("required", "true");
        }
        if (ramlType == ScalarType.INTEGER || ramlType == ScalarType.NUMBER) {
            if (parameter.getAnnotation(Min.class).isPresent()) {
                this.writer.appendLine("minimum", String.valueOf(((Min)parameter.getAnnotation(Min.class).get()).value()));
            }
            if (parameter.getAnnotation(Max.class).isPresent()) {
                this.writer.appendLine("maximum", String.valueOf(((Max)parameter.getAnnotation(Max.class).get()).value()));
            }
        }
        if (parameter.getAnnotation(Size.class).isPresent() && ramlType == ScalarType.STRING) {
            this.writer.appendLine("minLength", String.valueOf(((Size)parameter.getAnnotation(Size.class).get()).min()));
            this.writer.appendLine("maxLength", String.valueOf(((Size)parameter.getAnnotation(Size.class).get()).max()));
        }
        this.writer.outdent();
    }
}

