/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import org.raml.api.RamlEntity;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.handlers.FieldAnnotable;
import org.raml.jaxrs.handlers.MethodAnnotable;
import org.raml.jaxrs.handlers.PluginUtilities;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeScanner;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;

public class SimpleJacksonTypes
implements TypeHandler {
    @Override
    public void writeType(TypeRegistry registry, IndentedAppendable writer, RamlMediaType ramlMediaType, RamlResourceMethod method, RamlEntity type) throws IOException {
        this.writeBody(registry, writer, ramlMediaType, type);
    }

    private void writeBody(TypeRegistry registry, IndentedAppendable writer, RamlMediaType mediaTypes, RamlEntity bodyType) throws IOException {
        Class type = (Class)bodyType.getType();
        writer.appendLine("type", type.getSimpleName());
        registry.registerType(type.getSimpleName(), bodyType, new SimpleJaxbTypeScanner());
    }

    private static class SimpleJaxbTypeScanner
    implements TypeScanner {
        private SimpleJaxbTypeScanner() {
        }

        @Override
        public void scanType(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType) {
            Class c = (Class)type.getType();
            this.forFields(typeRegistry, type, ramlType, c);
            this.forProperties(typeRegistry, type, ramlType, c);
        }

        private void forProperties(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || Modifier.isStatic(method.getModifiers())) continue;
                Type genericType = method.getGenericReturnType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, method.getReturnType().getSimpleName(), type.createDependent(genericType));
                JsonProperty elem = method.getAnnotation(JsonProperty.class);
                if (elem == null) continue;
                String name = elem.value().equals("") ? this.buildName(method) : elem.value();
                ramlType.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), name, fieldRamlType));
            }
        }

        private void forFields(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c) {
            for (Field field : c.getDeclaredFields()) {
                Type genericType = field.getGenericType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, field.getType().getSimpleName(), type.createDependent(genericType));
                JsonProperty elem = field.getAnnotation(JsonProperty.class);
                if (elem == null) continue;
                String name = elem.value().equals("") ? field.getName() : elem.value();
                ramlType.addProperty(RamlProperty.createProperty(new FieldAnnotable(field), name, fieldRamlType));
            }
        }

        private String buildName(Method method) {
            if (method.getName().startsWith("is")) {
                return Introspector.decapitalize(method.getName().substring(2));
            }
            return Introspector.decapitalize(method.getName().substring(3));
        }
    }
}

