/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.handlers;

import com.google.common.base.Optional;
import java.beans.Introspector;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Type;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlTransient;
import org.raml.api.Annotable;
import org.raml.api.RamlEntity;
import org.raml.api.RamlMediaType;
import org.raml.api.RamlResourceMethod;
import org.raml.jaxrs.handlers.MethodAnnotable;
import org.raml.jaxrs.handlers.PluginUtilities;
import org.raml.jaxrs.plugins.TypeHandler;
import org.raml.jaxrs.plugins.TypeScanner;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.jaxrs.types.RamlType;
import org.raml.jaxrs.types.TypeRegistry;
import org.raml.utilities.IndentedAppendable;

public class SimpleJaxbTypes
implements TypeHandler {
    @Override
    public void writeType(TypeRegistry registry, IndentedAppendable writer, RamlMediaType ramlMediaType, RamlResourceMethod method, RamlEntity type) throws IOException {
        this.writeBody(registry, writer, ramlMediaType, type);
    }

    private void writeBody(TypeRegistry registry, IndentedAppendable writer, RamlMediaType mediaTypes, RamlEntity bodyType) throws IOException {
        Class type = (Class)bodyType.getType();
        writer.appendLine("type", type.getSimpleName());
        registry.registerType(type.getSimpleName(), bodyType, new SimpleJaxbTypeScanner());
    }

    private static class SimpleJaxbTypeScanner
    implements TypeScanner {
        private SimpleJaxbTypeScanner() {
        }

        @Override
        public void scanType(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType) {
            Class c = (Class)type.getType();
            XmlAccessorType accessorType = c.getAnnotation(XmlAccessorType.class);
            XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
            if (accessorType != null) {
                accessType = accessorType.value();
            }
            switch (accessType) {
                case NONE: {
                    break;
                }
                case FIELD: {
                    this.forFields(typeRegistry, type, ramlType, c, false);
                    this.forProperties(typeRegistry, type, ramlType, c, true, false);
                    break;
                }
                case PROPERTY: {
                    this.forProperties(typeRegistry, type, ramlType, c, false, false);
                    this.forFields(typeRegistry, type, ramlType, c, true);
                    break;
                }
                case PUBLIC_MEMBER: {
                    this.forProperties(typeRegistry, type, ramlType, c, false, true);
                    this.forFields(typeRegistry, type, ramlType, c, true);
                }
            }
        }

        private void forProperties(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c, boolean explicitOnly, boolean publicOnly) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.getName().startsWith("get") && !method.getName().startsWith("is") || publicOnly && !Modifier.isPublic(method.getModifiers()) || Modifier.isStatic(method.getModifiers()) || method.isAnnotationPresent(XmlTransient.class)) continue;
                Type genericType = method.getGenericReturnType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, method.getReturnType().getSimpleName(), type.createDependent(genericType));
                if (explicitOnly && !method.isAnnotationPresent(XmlAttribute.class) && !method.isAnnotationPresent(XmlElement.class)) continue;
                XmlElement elem = method.getAnnotation(XmlElement.class);
                if (elem != null) {
                    String name = elem.name().equals("##default") ? this.buildName(method) : elem.name();
                    ramlType.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), name, fieldRamlType));
                    continue;
                }
                XmlAttribute attribute = method.getAnnotation(XmlAttribute.class);
                if (attribute != null) {
                    String name = elem.name().equals("##default") ? this.buildName(method) : elem.name();
                    ramlType.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), name, fieldRamlType));
                    continue;
                }
                ramlType.addProperty(RamlProperty.createProperty(new MethodAnnotable(method), this.buildName(method), fieldRamlType));
            }
        }

        private void forFields(TypeRegistry typeRegistry, RamlEntity type, RamlType ramlType, Class c, boolean explicitOnly) {
            for (Field field : c.getDeclaredFields()) {
                if (field.isAnnotationPresent(XmlTransient.class) || Modifier.isTransient(field.getModifiers()) || explicitOnly && !field.isAnnotationPresent(XmlAttribute.class) && !field.isAnnotationPresent(XmlElement.class)) continue;
                Type genericType = field.getGenericType();
                RamlType fieldRamlType = PluginUtilities.getRamlType(typeRegistry, this, field.getType().getSimpleName(), type.createDependent(genericType));
                XmlElement elem = field.getAnnotation(XmlElement.class);
                if (elem != null) {
                    String name = elem.name().equals("##default") ? field.getName() : elem.name();
                    ramlType.addProperty(RamlProperty.createProperty(new FieldAnnotable(field), name, fieldRamlType));
                    continue;
                }
                XmlAttribute attribute = field.getAnnotation(XmlAttribute.class);
                if (attribute != null) {
                    String name = elem.name().equals("##default") ? field.getName() : elem.name();
                    ramlType.addProperty(RamlProperty.createProperty(new FieldAnnotable(field), name, fieldRamlType));
                    continue;
                }
                ramlType.addProperty(RamlProperty.createProperty(new FieldAnnotable(field), field.getName(), fieldRamlType));
            }
        }

        private String buildName(Method method) {
            if (method.getName().startsWith("is")) {
                return Introspector.decapitalize(method.getName().substring(2));
            }
            return Introspector.decapitalize(method.getName().substring(3));
        }

        private static class FieldAnnotable
        implements Annotable {
            private final Field field;

            public FieldAnnotable(Field field) {
                this.field = field;
            }

            public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
                return Optional.fromNullable(this.field.getAnnotation(annotationType));
            }
        }
    }
}

