/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.types;

import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.collect.Collections2;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.api.Annotable;
import org.raml.api.RamlData;
import org.raml.api.ScalarType;
import org.raml.jaxrs.emitters.AnnotationInstanceEmitter;
import org.raml.jaxrs.emitters.Emittable;
import org.raml.jaxrs.emitters.ExampleEmitter;
import org.raml.jaxrs.emitters.LocalEmitter;
import org.raml.jaxrs.types.RamlProperty;
import org.raml.utilities.IndentedAppendable;

public class RamlType
implements Annotable,
Emittable {
    private final RamlData type;
    private final boolean collection;
    private Map<String, RamlProperty> properties = new HashMap<String, RamlProperty>();
    private List<RamlType> superTypes;

    public RamlType(RamlData type) {
        this.type = type;
        this.collection = false;
    }

    public RamlType(RamlData type, boolean collection) {
        this.type = type;
        this.collection = collection;
    }

    public static RamlType collectionOf(RamlType collectionType) {
        return new RamlType(collectionType.type, true);
    }

    public void addProperty(RamlProperty property) {
        this.properties.put(property.getName(), property);
    }

    public void write(AnnotationInstanceEmitter emitter, IndentedAppendable writer) throws IOException {
        Class c = (Class)this.type.getType();
        writer.appendLine(c.getSimpleName() + ":");
        writer.indent();
        if (this.superTypes != null && this.superTypes.size() > 0) {
            writer.appendList("type", Collections2.transform(this.superTypes, (Function)new Function<RamlType, String>(){

                public String apply(RamlType input) {
                    return input.getTypeName();
                }
            }).toArray(new String[0]));
        }
        emitter.emit(this);
        this.writeExample(writer);
        if (this.type.getDescription().isPresent()) {
            writer.appendLine("description: " + (String)this.type.getDescription().get());
        }
        writer.appendLine("properties:");
        writer.indent();
        for (RamlProperty ramlProperty : this.properties.values()) {
            ramlProperty.write(emitter, writer);
        }
        writer.outdent();
        writer.outdent();
    }

    public void writeExample(IndentedAppendable writer) throws IOException {
        this.emit(new ExampleEmitter(writer));
    }

    public String getTypeName() {
        Optional st = ScalarType.fromType((Type)this.type.getType());
        if (st.isPresent()) {
            if (this.collection) {
                return ((ScalarType)st.get()).getRamlSyntax() + "[]";
            }
            return ((ScalarType)st.get()).getRamlSyntax();
        }
        Class c = (Class)this.type.getType();
        if (this.collection) {
            return c.getSimpleName() + "[]";
        }
        return c.getSimpleName();
    }

    public void setSuperTypes(List<RamlType> superTypes) {
        this.superTypes = superTypes;
    }

    public <T extends Annotation> Optional<T> getAnnotation(Class<T> annotationType) {
        return this.type.getAnnotation(annotationType);
    }

    public boolean isRamlScalarType() {
        Optional st = ScalarType.fromType((Type)this.type.getType());
        return st.isPresent();
    }

    @Override
    public void emit(LocalEmitter emitter) throws IOException {
        emitter.emit(this);
    }

    public Collection<RamlProperty> getProperties() {
        return this.properties.values();
    }
}

