/*
 * Copyright 2013 (c) MuleSoft, Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND,
 * either express or implied. See the License for the specific
 * language governing permissions and limitations under the License.
 */
package org.raml.v2.impl.commons.nodes;

import javax.annotation.Nonnull;

import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.KeyValueNodeImpl;

public class ResourceNode extends KeyValueNodeImpl
{

    public ResourceNode()
    {
    }

    public ResourceNode(ResourceNode node)
    {
        super(node);
    }

    public String getRelativeUri()
    {
        Node key = getKey();
        if (key instanceof StringNode)
        {
            return ((StringNode) key).getValue();
        }
        else
        {
            throw new IllegalStateException("Key must be a string but was a " + key.getClass());
        }
    }

    public String getResourcePath()
    {
        String path = getRelativeUri();
        ResourceNode parent = getParentResourceNode();
        if (parent != null)
        {
            path = parent.getResourcePath() + path;
        }
        return path;
    }

    private ResourceNode getParentResourceNode()
    {
        Node parent = getParent();
        if (parent != null && parent.getParent() instanceof ResourceNode)
        {
            return (ResourceNode) parent.getParent();
        }
        return null;
    }

    public String getResourcePathName()
    {
        String path = getRelativeUri().substring(1); // remove leading slash
        path = path.replace("{", "");
        return path.replace("}", "");
    }

    @Nonnull
    @Override
    public Node copy()
    {
        return new ResourceNode(this);
    }
}
