/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.ConditionalRule;
import org.raml.v2.grammar.rule.KeyValueRule;
import org.raml.v2.nodes.Node;
import org.raml.v2.utils.NodeSelector;

public class ConditionalRules {
    private String selectorExpression;
    private List<ConditionalRule> options;
    private Node defaultValue;

    public ConditionalRules(String selectorExpression, ConditionalRule ... cases) {
        this.selectorExpression = selectorExpression;
        this.options = Arrays.asList(cases);
    }

    @Nonnull
    public List<KeyValueRule> getRulesNode(Node node) {
        Node from = NodeSelector.selectFrom(this.selectorExpression, node);
        if (from == null) {
            from = this.defaultValue;
        }
        if (from != null) {
            for (ConditionalRule option : this.options) {
                if (!option.matches(from)) continue;
                return option.getRules();
            }
        }
        return Collections.emptyList();
    }

    public ConditionalRules defaultValue(Node node) {
        this.defaultValue = node;
        return this;
    }
}

