/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.math.BigDecimal;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.nodes.FloatingNode;
import org.raml.v2.nodes.IntegerNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.SimpleTypeNode;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public class MinimumValueRule
extends Rule {
    private Number minimumValue;

    public MinimumValueRule(Number minimumValue) {
        this.minimumValue = minimumValue;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.emptyList();
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof IntegerNode) {
            return ((IntegerNode)node).getValue().compareTo(this.minimumValue.intValue()) >= 0;
        }
        return node instanceof FloatingNode && ((FloatingNode)node).getValue().compareTo(new BigDecimal(this.minimumValue.floatValue())) >= 0;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        if (this.matches(node)) {
            return this.createNodeUsingFactory(node, ((SimpleTypeNode)node).getValue());
        }
        return ErrorNodeFactory.createInvalidMinimumValue(this.minimumValue);
    }

    @Override
    public String getDescription() {
        return "Minimum value";
    }
}

