/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.grammar.rule.ObjectRule;
import org.raml.v2.grammar.rule.ReferenceSuggester;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ParametrizedReferenceNode;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public class ParametrizedNodeReferenceRule
extends ObjectRule {
    private ReferenceSuggester suggester;

    public ParametrizedNodeReferenceRule(String referenceKey) {
        this.suggester = new ReferenceSuggester(referenceKey);
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return super.matches(node) && this.hasOneKey(node) || node instanceof ParametrizedReferenceNode;
    }

    private boolean hasOneKey(@Nonnull Node node) {
        return !node.getChildren().isEmpty() && !node.getChildren().get(0).getChildren().isEmpty();
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        switch (pathToRoot.size()) {
            case 1: {
                return this.getSuggestions(pathToRoot.get(0), context);
            }
        }
        return Collections.emptyList();
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        if (this.hasOneKey(node)) {
            Node key = node.getChildren().get(0).getChildren().get(0);
            return this.suggester.getSuggestions(key);
        }
        return super.getSuggestions(node, context);
    }

    @Override
    protected Node getResult(Node node) {
        if (node instanceof ParametrizedReferenceNode) {
            return node;
        }
        String arg = node.getChildren().get(0).getChildren().get(0).toString();
        return this.createNodeUsingFactory(node, arg);
    }

    @Override
    public String getDescription() {
        return "Parametrized reference call.";
    }
}

