/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.nodes.ArrayNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.suggester.DefaultSuggestion;
import org.raml.v2.suggester.Suggestion;
import org.raml.v2.utils.NodeSelector;

public class ReferenceSuggester {
    private String referenceKey;

    public ReferenceSuggester(String referenceKey) {
        this.referenceKey = referenceKey;
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        Node contextNode = node.getRootNode();
        if (node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            String[] library = value.split("\\.");
            for (int i = 0; i < library.length - 1 && contextNode != null; ++i) {
                contextNode = NodeSelector.selectFrom("uses/*/" + library[i], contextNode);
            }
        }
        if (contextNode != null) {
            Node selectFrom = NodeSelector.selectFrom(this.referenceKey, contextNode);
            this.addSuggestions(result, selectFrom);
            Node libraries = NodeSelector.selectFrom("uses", contextNode);
            this.addSuggestions(result, libraries);
        }
        return result;
    }

    private void addSuggestions(List<Suggestion> result, Node selectFrom) {
        if (selectFrom != null) {
            if (selectFrom instanceof ObjectNode) {
                this.collectSuggestions(result, selectFrom);
            } else if (selectFrom instanceof ArrayNode) {
                List<Node> children = selectFrom.getChildren();
                for (Node child : children) {
                    this.collectSuggestions(result, child);
                }
            }
        }
    }

    private void collectSuggestions(List<Suggestion> result, Node selectFrom) {
        List<Node> children = selectFrom.getChildren();
        for (Node child : children) {
            if (child.getChildren().isEmpty()) continue;
            String value = child.getChildren().get(0).toString();
            Node description = NodeSelector.selectFrom("usage", child.getChildren().get(1));
            String descriptionText = "";
            if (description != null) {
                descriptionText = description.toString();
            } else {
                Node usage = NodeSelector.selectFrom("description", child.getChildren().get(1));
                if (usage != null) {
                    descriptionText = usage.toString();
                }
            }
            result.add(new DefaultSuggestion(value, descriptionText, value));
        }
    }
}

