/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.grammar.rule;

import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.grammar.rule.ErrorNodeFactory;
import org.raml.v2.grammar.rule.Rule;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.NodeType;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.suggester.DefaultSuggestion;
import org.raml.v2.suggester.RamlParsingContext;
import org.raml.v2.suggester.Suggestion;

public class StringValueRule
extends Rule {
    private String value;
    private String description;

    public StringValueRule(String value) {
        this.value = value;
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Collections.singletonList(new DefaultSuggestion(this.value, this.description, StringUtils.capitalize((String)this.value)));
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        return node instanceof StringNode && ((StringNode)node).getValue().equals(this.value);
    }

    public StringValueRule description(String description) {
        this.description = description;
        return this;
    }

    @Override
    @Nonnull
    public Node apply(@Nonnull Node node) {
        if (!(node instanceof StringNode)) {
            return ErrorNodeFactory.createInvalidType(node, NodeType.String);
        }
        if (!this.matches(node)) {
            return ErrorNodeFactory.createInvalidValue(node, this.value);
        }
        return this.createNodeUsingFactory(node, ((StringNode)node).getValue());
    }

    public String toString() {
        return this.value;
    }

    @Override
    public String getDescription() {
        return "\"" + this.value + "\"";
    }

    public String getValue() {
        return this.value;
    }
}

