/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.model;

import java.util.ArrayList;
import java.util.List;
import org.raml.v2.impl.commons.model.DocumentationItem;
import org.raml.v2.impl.commons.model.GlobalSchema;
import org.raml.v2.impl.commons.model.LibraryBase;
import org.raml.v2.impl.commons.model.Resource;
import org.raml.v2.impl.commons.model.SecuritySchemeRef;
import org.raml.v2.impl.commons.model.StringType;
import org.raml.v2.impl.commons.model.TypeDeclaration;
import org.raml.v2.impl.commons.nodes.RamlDocumentNode;
import org.raml.v2.impl.commons.nodes.ResourceNode;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.utils.NodeSelector;

public class Api
extends LibraryBase {
    private RamlDocumentNode node;

    public Api(RamlDocumentNode delegateNode) {
        this.node = delegateNode;
    }

    @Override
    protected Node getNode() {
        return this.node;
    }

    public String title() {
        return this.getStringValue("title");
    }

    public String version() {
        return this.getStringValue("version");
    }

    public StringType baseUri() {
        return this.getStringTypeValue("baseUri");
    }

    public List<StringType> mediaType() {
        return this.getList("mediaType", StringType.class);
    }

    public List<DocumentationItem> documentation() {
        return this.getList("documentation", DocumentationItem.class);
    }

    public List<Resource> resources() {
        ArrayList<Resource> resultList = new ArrayList<Resource>();
        for (Node item : this.node.getChildren()) {
            if (!(item instanceof ResourceNode)) continue;
            resultList.add(new Resource((ResourceNode)item));
        }
        return resultList;
    }

    public List<String> protocols() {
        ArrayList<String> resultList = new ArrayList<String>();
        Node parent = NodeSelector.selectFrom("protocols", (Node)this.node);
        for (Node child : parent.getChildren()) {
            resultList.add(child.toString());
        }
        return resultList;
    }

    public List<SecuritySchemeRef> securedBy() {
        return this.getList("securedBy", SecuritySchemeRef.class);
    }

    public List<TypeDeclaration> types() {
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>();
        Node typesNode = NodeSelector.selectFrom("types", (Node)this.node);
        if (typesNode != null) {
            for (Node child : typesNode.getChildren()) {
                result.add(new TypeDeclaration((KeyValueNode)child));
            }
        }
        return result;
    }

    public List<TypeDeclaration> schemas() {
        ArrayList<TypeDeclaration> result = new ArrayList<TypeDeclaration>();
        Node typesNode = NodeSelector.selectFrom("schemas", (Node)this.node);
        if (typesNode != null) {
            for (Node child : typesNode.getChildren()) {
                result.add(new TypeDeclaration((KeyValueNode)child));
            }
        }
        return result;
    }

    public List<GlobalSchema> schemasV08() {
        ArrayList<GlobalSchema> result = new ArrayList<GlobalSchema>();
        Node typesNode = NodeSelector.selectFrom("schemas", (Node)this.node);
        if (typesNode != null) {
            for (Node child : typesNode.getChildren()) {
                result.add(new GlobalSchema((KeyValueNode)child));
            }
        }
        return result;
    }
}

