/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.phase;

import org.raml.v2.impl.commons.nodes.ExtendsNode;
import org.raml.v2.nodes.ArrayNode;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.SimpleTypeNode;
import org.raml.v2.utils.NodeSelector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExtensionsMerger {
    private static final Logger logger = LoggerFactory.getLogger(ExtensionsMerger.class);

    public static void merge(Node baseNode, Node copyNode) {
        if (baseNode instanceof ObjectNode && copyNode instanceof ObjectNode) {
            ExtensionsMerger.merge((ObjectNode)baseNode, (ObjectNode)copyNode);
        } else if (baseNode instanceof ArrayNode && copyNode instanceof ArrayNode) {
            ExtensionsMerger.merge((ArrayNode)baseNode, (ArrayNode)copyNode);
        } else {
            throw new RuntimeException(String.format("Merging not supported for nodes of type %s and %s", baseNode.getClass().getSimpleName(), copyNode.getClass().getSimpleName()));
        }
    }

    static void merge(ArrayNode baseNode, ArrayNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            baseNode.addChild(child);
        }
    }

    static void merge(ObjectNode baseNode, ObjectNode copyNode) {
        for (Node child : copyNode.getChildren()) {
            if (!(child instanceof KeyValueNode)) {
                throw new RuntimeException("only expecting KeyValueNode");
            }
            Node keyNode = ((KeyValueNode)child).getKey();
            String key = keyNode.toString();
            if (ExtensionsMerger.shouldIgnoreNode(child)) {
                logger.info("Ignoring key '{}'", (Object)key);
                continue;
            }
            Node node = NodeSelector.selectFrom(key, (Node)baseNode);
            if (node == null) {
                logger.info("Adding key '{}'", (Object)key);
                baseNode.addChild(child);
                continue;
            }
            if (((KeyValueNode)child).getValue() instanceof SimpleTypeNode) {
                logger.info("Replacing existing scalar key '{}'", (Object)key);
                node.replaceWith(((KeyValueNode)child).getValue());
                continue;
            }
            logger.info("Merging values '{}' and '{}'", (Object)node.getParent(), (Object)child);
            ExtensionsMerger.merge(node, ((KeyValueNode)child).getValue());
        }
    }

    private static boolean shouldIgnoreNode(Node node) {
        return node instanceof ExtendsNode;
    }
}

