/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.commons.phase;

import java.util.List;
import org.raml.v2.impl.commons.model.BuiltInScalarType;
import org.raml.v2.impl.v10.nodes.types.builtin.BooleanTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.NumericTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.StringTypeNode;
import org.raml.v2.nodes.KeyValueNode;
import org.raml.v2.nodes.KeyValueNodeImpl;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.StringNodeImpl;
import org.raml.v2.nodes.snakeyaml.SYNullNode;
import org.raml.v2.nodes.snakeyaml.SYStringNode;
import org.raml.v2.phase.Phase;
import org.raml.v2.utils.NodeUtils;

public class SugarRushPhase
implements Phase {
    @Override
    public Node apply(Node tree) {
        this.sweetenBuiltInTypes(tree);
        this.sweetenObjects(tree);
        this.sweetenAnnotations(tree);
        return tree;
    }

    private void sweetenBuiltInTypes(Node tree) {
        List<StringNode> basicSugar = tree.findDescendantsWith(StringNode.class);
        for (StringNode sugarNode : basicSugar) {
            if (BuiltInScalarType.isBuiltInScalarType(sugarNode.getValue()) && !this.isTypePresentBasic(sugarNode)) {
                this.handleBuiltInType(sugarNode);
                continue;
            }
            if ("array".equals(sugarNode.getValue())) {
                this.handleArray(sugarNode);
                continue;
            }
            if (!this.isArraySugar(sugarNode)) continue;
            this.handleObjectArray(sugarNode);
        }
    }

    private void sweetenObjects(Node tree) {
        List<StringNode> basicSugar = tree.findDescendantsWith(StringNode.class);
        for (StringNode sugarNode : basicSugar) {
            if (!"properties".equals(sugarNode.getValue()) || this.isTypePresentObject(sugarNode)) continue;
            Node grandParent = sugarNode.getParent().getParent();
            grandParent.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("object")));
        }
    }

    private void sweetenTypeSystemObjects(Node tree) {
        List<StringNode> basicSugar = tree.findDescendantsWith(StringNode.class);
        for (StringNode sugarNode : basicSugar) {
            if (!this.isTypeSystemObjectProperty(sugarNode) || !sugarNode.getChildren().isEmpty() || !this.isValidTypeSystemObject(tree, sugarNode)) continue;
            ObjectTypeNode newNode = new ObjectTypeNode();
            newNode.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl(sugarNode.getValue())));
            sugarNode.replaceWith(newNode);
        }
    }

    private void sweetenAnnotations(Node tree) {
        Node annotationsNode = tree.get("annotationTypes");
        if (annotationsNode != null) {
            for (Node annotation : annotationsNode.getChildren()) {
                if (!this.isTypeMissingInAnnotation(annotation) || !this.isStringAnnotation(annotation)) continue;
                this.setTypeString(annotation);
            }
        }
    }

    private void handleObjectArray(StringNode sugarNode) {
        String keyString;
        Node parent = sugarNode.getParent();
        Node key = this.isKeyValueNode(parent) ? ((KeyValueNode)parent).getKey() : null;
        String string = keyString = key instanceof StringNode ? ((StringNode)key).getValue() : null;
        if (parent instanceof KeyValueNode && "type".equals(keyString)) {
            Node grandParent = parent.getParent();
            grandParent.removeChild(parent);
            KeyValueNodeImpl items = this.handleArraySugar(sugarNode, grandParent);
            items.setSource(parent);
            grandParent.addChild(items);
        } else {
            ObjectTypeNode newNode = new ObjectTypeNode();
            KeyValueNodeImpl items = this.handleArraySugar(sugarNode, newNode);
            items.setSource(parent);
            newNode.addChild(items);
            sugarNode.replaceWith(newNode);
        }
    }

    private boolean isArraySugar(StringNode sugarNode) {
        return sugarNode.getValue() != null && sugarNode.getValue().endsWith("[]");
    }

    private void handleArray(StringNode sugarNode) {
        Node itemsNode;
        if (sugarNode.getParent() != null && sugarNode.getParent().getParent() != null && (itemsNode = sugarNode.getParent().getParent().get("items")) instanceof SYNullNode) {
            itemsNode.replaceWith(new StringNodeImpl(new StringNodeImpl("string")));
        }
    }

    private KeyValueNodeImpl handleArraySugar(StringNode sugarNode, Node grandParent) {
        String value = sugarNode.getValue().split("\\[")[0];
        grandParent.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("array")));
        return new KeyValueNodeImpl(new StringNodeImpl("items"), new StringNodeImpl(value));
    }

    private void handleBuiltInType(StringNode sugarNode) {
        Node newNode;
        if (sugarNode.getChildren().isEmpty() && (newNode = this.getSugarNode(sugarNode.getValue())) != null) {
            newNode.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl(sugarNode.getValue())));
            this.handleExample(sugarNode, newNode);
            sugarNode.replaceWith(newNode);
        }
    }

    private void setTypeString(Node annotation) {
        if (this.isKeyValueNode(annotation)) {
            StringTypeNode stringTypeNode = new StringTypeNode();
            stringTypeNode.addChild(new KeyValueNodeImpl(new StringNodeImpl("type"), new StringNodeImpl("string")));
            ((KeyValueNode)annotation).getValue().replaceWith(stringTypeNode);
        }
    }

    private boolean isStringAnnotation(Node annotation) {
        return this.isKeyValueNode(annotation) && ((KeyValueNode)annotation).getValue().get("properties") == null;
    }

    private boolean isKeyValueNode(Node annotation) {
        return annotation instanceof KeyValueNode;
    }

    private boolean isTypeMissingInAnnotation(Node annotation) {
        return this.isKeyValueNode(annotation) && NodeUtils.getType(((KeyValueNode)annotation).getValue()) == null;
    }

    private boolean isValidTypeSystemObject(Node tree, StringNode sugarNode) {
        Node types = tree.get("types");
        String value = sugarNode.getValue();
        if (this.isUnion(sugarNode) || value.endsWith("[]")) {
            return true;
        }
        if (types != null) {
            Node object = types.get(value);
            return object != null && object instanceof ObjectNode;
        }
        return false;
    }

    private boolean isUnion(StringNode sugarNode) {
        String value = sugarNode.getValue();
        if (this.isKeyValueNode(sugarNode.getParent())) {
            KeyValueNode parent = (KeyValueNode)sugarNode.getParent();
            String key = ((StringNode)parent.getKey()).getValue();
            return value.contains("|") && !"type".equals(key) && !"pattern".equals(key);
        }
        return false;
    }

    private boolean isTypeSystemObjectProperty(StringNode sugarNode) {
        if (this.isUnion(sugarNode)) {
            return true;
        }
        Node properties = sugarNode.getParent().getParent().getParent();
        if (properties != null) {
            KeyValueNode parentNode;
            Node type = properties.getParent();
            if (this.isKeyValueNode(sugarNode.getParent()) && (parentNode = (KeyValueNode)sugarNode.getParent()).getValue() instanceof StringNode && ((StringNode)parentNode.getValue()).getValue().equals(sugarNode.getValue()) && NodeUtils.getType(type) != null) {
                return true;
            }
        }
        return false;
    }

    private void handleExample(Node sugarNode, Node newNode) {
        Node example = sugarNode.getParent().getParent().get("example");
        if (example != null) {
            Node exampleRoot = example.getParent();
            exampleRoot.getParent().removeChild(exampleRoot);
            newNode.addChild(exampleRoot);
        }
    }

    private boolean isTypePresentBasic(Node sugarNode) {
        Node parent = sugarNode.getParent();
        if (this.isKeyValueNode(parent) && ((KeyValueNode)parent).getKey() instanceof SYStringNode) {
            SYStringNode key = (SYStringNode)((KeyValueNode)parent).getKey();
            return "type".equals(key.getValue());
        }
        return false;
    }

    private boolean isTypePresentObject(Node sugarNode) {
        return NodeUtils.getType(sugarNode.getParent().getParent()) != null;
    }

    private Node getSugarNode(String typeNode) {
        if (BuiltInScalarType.STRING.getType().equals(typeNode)) {
            return new StringTypeNode();
        }
        if (BuiltInScalarType.NUMBER.getType().equals(typeNode) || BuiltInScalarType.INTEGER.getType().equals(typeNode)) {
            return new NumericTypeNode();
        }
        if (BuiltInScalarType.BOOLEAN.getType().equals(typeNode)) {
            return new BooleanTypeNode();
        }
        if ("object".equals(typeNode)) {
            return new ObjectTypeNode();
        }
        return null;
    }
}

