/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.v10.nodes.types.builtin;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.impl.commons.nodes.PropertyNode;
import org.raml.v2.impl.v10.nodes.types.InheritedPropertiesInjectedNode;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.TypeNodeVisitor;
import org.raml.v2.impl.v10.nodes.types.builtin.UnionTypeNode;
import org.raml.v2.nodes.AbstractRamlNode;
import org.raml.v2.nodes.IntegerNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.NodeType;
import org.raml.v2.nodes.ObjectNode;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.utils.NodeUtils;

public class ObjectTypeNode
extends AbstractRamlNode
implements ObjectNode,
TypeNode {
    private List<InheritedPropertiesInjectedNode> inheritedProperties = Lists.newArrayList();

    public ObjectTypeNode() {
    }

    protected ObjectTypeNode(ObjectTypeNode node) {
        super(node);
    }

    public List<PropertyNode> getProperties() {
        ArrayList<PropertyNode> result = new ArrayList<PropertyNode>();
        List<Object> properties = Lists.newArrayList();
        if (this.getSource().get("properties") != null) {
            properties = this.getSource().get("properties").getChildren();
        } else if (this.get("properties") != null) {
            properties = this.get("properties").getChildren();
        } else if (NodeUtils.getType(this) instanceof StringNode) {
            if ("array".equals(((StringNode)NodeUtils.getType(this)).getValue()) && this.get("items") != null && this.get("items") instanceof UnionTypeNode) {
                return ((UnionTypeNode)this.get("items")).getProperties();
            }
            String typeName = ((StringNode)NodeUtils.getType(this)).getValue();
            TypeNode typeNode = NodeUtils.getType(typeName, this);
            if (typeNode != null) {
                return ((ObjectTypeNode)typeNode).getProperties();
            }
        }
        for (Node node : properties) {
            result.add((PropertyNode)node);
        }
        return result;
    }

    @Override
    @Nonnull
    public Node copy() {
        return new ObjectTypeNode(this);
    }

    @Override
    public NodeType getType() {
        return NodeType.Object;
    }

    public void addInheritedProperties(InheritedPropertiesInjectedNode node) {
        this.inheritedProperties.add(node);
    }

    public void setInheritedProperties(List<InheritedPropertiesInjectedNode> inheritedProperties) {
        this.inheritedProperties = inheritedProperties;
    }

    public List<InheritedPropertiesInjectedNode> getInheritedProperties() {
        return this.inheritedProperties;
    }

    @Override
    public <T> T visit(TypeNodeVisitor<T> visitor) {
        return visitor.visitObject(this);
    }

    public boolean isArray() {
        return NodeUtils.getType(this) instanceof StringNode && "array".equals(((StringNode)NodeUtils.getType(this)).getValue());
    }

    public Integer getMinProperties() {
        return this.getIntFacet("minProperties");
    }

    public Integer getMaxProperties() {
        return this.getIntFacet("maxProperties");
    }

    private Integer getIntFacet(String facetName) {
        if (this.get(facetName) != null && this.get(facetName) instanceof IntegerNode) {
            return ((IntegerNode)this.get(facetName)).getValue();
        }
        return null;
    }

    public boolean isAllowAdditionalProperties() {
        Node additionalProperties = this.get("additionalProperties");
        return additionalProperties == null;
    }
}

