/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.impl.v10.nodes.types.factories;

import org.raml.v2.grammar.rule.NodeFactory;
import org.raml.v2.impl.v10.nodes.types.builtin.BooleanTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.DateTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.FileTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.NumericTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.ObjectTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.StringTypeNode;
import org.raml.v2.impl.v10.nodes.types.builtin.UnionTypeNode;
import org.raml.v2.nodes.Node;
import org.raml.v2.nodes.StringNode;
import org.raml.v2.nodes.snakeyaml.SYArrayNode;
import org.raml.v2.utils.NodeSelector;

public class TypeNodeFactory
implements NodeFactory {
    @Override
    public Node create(Object ... args) {
        Node typeNode = NodeSelector.selectFrom("type", (Node)args[0]);
        if (typeNode instanceof SYArrayNode) {
            return new ObjectTypeNode();
        }
        StringNode type = (StringNode)typeNode;
        if (type == null) {
            return new StringTypeNode();
        }
        String value = type.getValue();
        return TypeNodeFactory.createNodeFromType(value);
    }

    public static Node createNodeFromType(String value) {
        switch (value) {
            case "string": {
                return new StringTypeNode();
            }
            case "number": 
            case "integer": {
                return new NumericTypeNode();
            }
            case "boolean": {
                return new BooleanTypeNode();
            }
            case "file": {
                return new FileTypeNode();
            }
            case "object": {
                return new ObjectTypeNode();
            }
            case "date-only": 
            case "time-only": 
            case "datetime-only": 
            case "datetime": {
                return new DateTypeNode();
            }
        }
        return new UnionTypeNode();
    }
}

