/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.framework.grammar.rule.ErrorNodeFactory;
import org.raml.v2.internal.framework.grammar.rule.Rule;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class AnyOfRule
extends Rule {
    protected List<Rule> rules;

    public AnyOfRule(@Nonnull List<Rule> rules) {
        if (rules.isEmpty()) {
            throw new IllegalArgumentException("rules cannot be empty");
        }
        this.rules = rules;
    }

    public AnyOfRule(Rule ... rules) {
        this(Arrays.asList(rules));
    }

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        for (Rule rule : this.rules) {
            result.addAll(rule.getSuggestions(node, context));
        }
        return result;
    }

    @Nullable
    public Rule getMatchingRule(Node node) {
        for (Rule rule : this.rules) {
            if (!rule.matches(node)) continue;
            return rule;
        }
        return null;
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        for (Rule rule : this.rules) {
            if (!rule.matches(node)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Node apply(@Nonnull Node node) {
        for (Rule rule : this.rules) {
            if (!rule.matches(node)) continue;
            return this.createNodeUsingFactory(rule.apply(node), new Object[0]);
        }
        return ErrorNodeFactory.createInvalidNode(node);
    }

    @Override
    public String getDescription() {
        StringBuilder desc = new StringBuilder();
        desc.append("Any of :");
        int i = 0;
        for (Rule rule : this.rules) {
            if (i > 0) {
                desc.append(",");
            }
            desc.append(rule.getDescription());
            ++i;
        }
        return desc.toString();
    }

    @Override
    public List<Suggestion> getSuggestions(List<Node> pathToRoot, RamlParsingContext context) {
        if (!pathToRoot.isEmpty()) {
            Node peek = pathToRoot.get(0);
            Rule innerRule = this.getMatchingRule(peek);
            if (innerRule != null) {
                List<Suggestion> suggestions = innerRule.getSuggestions(pathToRoot, context);
                if (suggestions.isEmpty()) {
                    return this.getSuggestions(peek, context);
                }
                return suggestions;
            }
            return this.getSuggestions(peek, context);
        }
        return Collections.emptyList();
    }
}

