/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.model;

import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.Position;

public class RamlValidationResult
implements ValidationResult {
    private String message;
    private Position start;
    private Position end;

    public RamlValidationResult(String message) {
        this.message = message;
    }

    public RamlValidationResult(ErrorNode errorNode) {
        this.message = errorNode.getErrorMessage();
        this.start = errorNode.getStartPosition();
        this.end = errorNode.getEndPosition();
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder(this.message);
        if (this.start != null) {
            if (this.start.getResource() != null) {
                builder.append(" -- " + this.start.getResource());
            }
            if (this.start.getLine() != -1) {
                builder.append(" [line=").append(this.start.getLine() + 1).append(", col=").append(this.start.getColumn() + 1).append("]");
            }
        }
        return builder.toString();
    }
}

