/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.grammar.rule;

import java.util.Arrays;
import java.util.List;
import javax.annotation.Nonnull;
import org.raml.v2.internal.framework.grammar.rule.AbstractTypeRule;
import org.raml.v2.internal.framework.nodes.BooleanNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.NodeType;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.framework.suggester.DefaultSuggestion;
import org.raml.v2.internal.framework.suggester.RamlParsingContext;
import org.raml.v2.internal.framework.suggester.Suggestion;

public class BooleanTypeRule
extends AbstractTypeRule {
    private static final String TRUE = "true";
    private static final String FALSE = "false";

    @Override
    @Nonnull
    public List<Suggestion> getSuggestions(Node node, RamlParsingContext context) {
        return Arrays.asList(new DefaultSuggestion(TRUE, "Boolean true", ""), new DefaultSuggestion(FALSE, "Boolean false", ""));
    }

    @Override
    public boolean matches(@Nonnull Node node) {
        if (node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            return TRUE.equals(value) || FALSE.equals(value);
        }
        return node instanceof BooleanNode;
    }

    @Override
    public String getDescription() {
        return "Boolean";
    }

    @Override
    @Nonnull
    NodeType getType() {
        return NodeType.Boolean;
    }
}

