/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.framework.suggester;

import org.raml.v2.internal.framework.suggester.Suggestion;

public class DefaultSuggestion
implements Suggestion,
Comparable<Suggestion> {
    public static final String RAML_1_0_HEADER = "RAML 1.0 Header";
    private String label;
    private String description;
    private String value;
    private String prefix;

    public DefaultSuggestion(String value, String description, String label) {
        this(value, description, label, "");
    }

    public DefaultSuggestion(String value, String description, String label, String prefix) {
        this.value = value;
        this.description = description;
        this.label = label;
        this.prefix = prefix;
    }

    @Override
    public String getPrefix() {
        return this.prefix;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    @Override
    public Suggestion withDescription(String description) {
        return new DefaultSuggestion(this.getValue(), description, this.getLabel());
    }

    @Override
    public Suggestion withValue(String value) {
        return new DefaultSuggestion(value, this.getDescription(), this.getLabel());
    }

    @Override
    public Suggestion withPrefix(String prefix) {
        return new DefaultSuggestion(this.getValue(), this.getDescription(), this.getLabel(), prefix);
    }

    public String toString() {
        return "DefaultSuggestion{label='" + this.label + '\'' + ", description='" + this.description + '\'' + ", value='" + this.value + '\'' + '}';
    }

    @Override
    public int compareTo(Suggestion other) {
        if (RAML_1_0_HEADER.equals(this.label)) {
            return -1;
        }
        if (RAML_1_0_HEADER.equals(other.getLabel())) {
            return 1;
        }
        return this.getLabel().compareTo(other.getLabel());
    }
}

