/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.utils;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.commons.lang.StringUtils;
import org.raml.v2.internal.framework.nodes.BooleanNode;
import org.raml.v2.internal.framework.nodes.ErrorNode;
import org.raml.v2.internal.framework.nodes.IntegerNode;
import org.raml.v2.internal.framework.nodes.Node;
import org.raml.v2.internal.framework.nodes.ReferenceNode;
import org.raml.v2.internal.framework.nodes.StringNode;
import org.raml.v2.internal.impl.v10.nodes.types.builtin.ObjectTypeNode;

public class TreeDumper {
    private static final int TAB_SPACES = 4;
    protected StringBuilder dump;
    private int indent = 0;

    private TreeDumper(StringBuilder dump) {
        this.dump = dump;
    }

    public TreeDumper() {
        this(new StringBuilder());
    }

    public String dump(Node node) {
        this.printIndent();
        this.dumpNode(node);
        this.dump.append(" (");
        this.dump.append("Start: ").append(node.getStartPosition().getIndex());
        this.dump.append(" , End: ").append(node.getEndPosition().getIndex());
        if (node.getSource() != null) {
            this.dump.append(", Source: ");
            this.dump.append(node.getSource().getClass().getSimpleName());
        }
        this.dump.append(")");
        this.dump.append("\n");
        this.indent();
        for (Node child : this.getChildren(node)) {
            this.dump(child);
        }
        this.dedent();
        return this.dump.toString();
    }

    private Collection<Node> getChildren(Node node) {
        ArrayList children = node.getChildren();
        if (node instanceof ObjectTypeNode) {
            ArrayList merged = Lists.newArrayList();
            merged.addAll(children);
            merged.addAll(((ObjectTypeNode)node).getInheritedProperties());
            children = merged;
        }
        return children;
    }

    protected void dumpNode(Node node) {
        this.dump.append(node.getClass().getSimpleName());
        if (node instanceof StringNode) {
            this.dump.append(": \"").append(((StringNode)node).getValue()).append("\"");
        }
        if (node instanceof IntegerNode) {
            this.dump.append(": ").append(((IntegerNode)node).getValue());
        }
        if (node instanceof BooleanNode) {
            this.dump.append(": ").append(((BooleanNode)node).getValue());
        } else if (node instanceof ErrorNode) {
            this.dump.append(": \"").append(((ErrorNode)node).getErrorMessage()).append("\"");
        } else if (node instanceof ReferenceNode) {
            Node refNode = ((ReferenceNode)node).getRefNode();
            this.dump.append(" -> {").append(refNode == null ? "null" : refNode.getClass().getSimpleName());
            if (refNode != null) {
                this.dump.append(" RefStart: ").append(refNode.getStartPosition().getIndex());
                this.dump.append(" , RefEnd: ").append(refNode.getEndPosition().getIndex());
            }
            this.dump.append("}");
        }
    }

    protected void dedent() {
        --this.indent;
    }

    protected void indent() {
        ++this.indent;
    }

    protected void printIndent() {
        this.dump.append(StringUtils.repeat((String)" ", (int)(this.indent * 4)));
    }
}

