/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.type;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.util.NodeSelector;

public abstract class BaseType
implements ResolvedType {
    protected ResolvedCustomFacets customFacets;
    private TypeExpressionNode typeExpressionNode;
    private String typeName;

    public BaseType(String typeName, TypeExpressionNode typeExpressionNode, ResolvedCustomFacets customFacets) {
        this.typeExpressionNode = typeExpressionNode;
        this.customFacets = customFacets;
        this.typeName = typeName;
    }

    @Override
    public ResolvedType setTypeNode(TypeExpressionNode typeNode) {
        BaseType copy = this.copy();
        copy.typeExpressionNode = typeNode;
        return copy;
    }

    protected abstract BaseType copy();

    @Override
    public ResolvedCustomFacets customFacets() {
        return this.customFacets;
    }

    protected void overwriteFacets(BaseType from, TypeDeclarationNode node) {
        if (node.getParent() instanceof TypeDeclarationField) {
            from.typeName = ((SimpleTypeNode)((TypeDeclarationField)node.getParent()).getKey()).getLiteralValue();
        } else if (!this.isTypeReference(node)) {
            from.typeName = this.getBuiltinTypeName();
        }
    }

    private boolean isTypeReference(TypeDeclarationNode node) {
        return node.getSource() instanceof SimpleTypeNode || this.isObjectWithOnlyTypeDecl(node);
    }

    protected boolean isObjectWithOnlyTypeDecl(Node node) {
        return node instanceof ObjectNode && node.getChildren().size() == 2 && NodeSelector.selectFrom((String)"type", (Node)node) != null && NodeSelector.selectFrom((String)"displayName", (Node)node) != null;
    }

    @Override
    public final boolean accepts(ResolvedType valueType) {
        if (valueType instanceof UnionResolvedType) {
            List<ResolvedType> toAcceptOptions = ((UnionResolvedType)valueType).of();
            for (ResolvedType toAcceptOption : toAcceptOptions) {
                if (this.doAccept(toAcceptOption)) continue;
                return false;
            }
            return true;
        }
        return this.doAccept(valueType);
    }

    public boolean doAccept(ResolvedType resolvedType) {
        return this.getClass().equals(resolvedType.getClass());
    }

    public void setTypeName(String typeName) {
        this.typeName = typeName;
    }

    @Override
    @Nullable
    public String getTypeName() {
        return this.typeName;
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return null;
    }

    @Override
    public TypeExpressionNode getTypeExpressionNode() {
        return this.typeExpressionNode;
    }

    @Override
    public void validateState() {
    }

    @Nonnull
    public static String getTypeName(TypeExpressionNode typeExpressionNode, String defaultName) {
        if (typeExpressionNode.getParent() instanceof TypeDeclarationField) {
            return ((SimpleTypeNode)((TypeDeclarationField)typeExpressionNode.getParent()).getKey()).getLiteralValue();
        }
        return defaultName;
    }
}

