/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.commons.phase;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.raml.v2.internal.impl.commons.nodes.StringTemplateNode;
import org.raml.v2.internal.impl.commons.nodes.TemplateExpressionNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.Position;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.phase.Transformer;

public class StringTemplateExpressionTransformer
implements Transformer {
    public static Pattern TEMPLATE_PATTERN = Pattern.compile("<<(.+?)>>");

    public boolean matches(Node node) {
        if (node instanceof StringNode) {
            String value = ((StringNode)node).getValue();
            return TEMPLATE_PATTERN.matcher(value).find();
        }
        return false;
    }

    public Node transform(Node node) {
        if (node instanceof StringTemplateNode) {
            return node;
        }
        String value = ((StringNode)node).getValue();
        StringTemplateNode stringTemplateNode = new StringTemplateNode(value);
        Matcher templateMatcher = TEMPLATE_PATTERN.matcher(value);
        Position startPosition = node.getStartPosition();
        int previousEndPosition = 0;
        while (templateMatcher.find()) {
            int start = templateMatcher.start();
            int end = templateMatcher.end();
            if (start > previousEndPosition) {
                StringNodeImpl stringNode = new StringNodeImpl(value.substring(previousEndPosition, start));
                stringNode.setStartPosition(startPosition.rightShift(previousEndPosition));
                stringNode.setEndPosition(startPosition.rightShift(start));
                stringTemplateNode.addChild((Node)stringNode);
            }
            TemplateExpressionNode expressionNode = new TemplateExpressionNode(templateMatcher.group(1));
            expressionNode.setStartPosition(startPosition.rightShift(templateMatcher.start(1)));
            expressionNode.setEndPosition(startPosition.rightShift(templateMatcher.end(1)));
            stringTemplateNode.addChild((Node)expressionNode);
            previousEndPosition = end;
        }
        if (value.length() > previousEndPosition) {
            StringNodeImpl stringNode = new StringNodeImpl(value.substring(previousEndPosition, value.length()));
            stringNode.setStartPosition(startPosition.rightShift(previousEndPosition));
            stringNode.setEndPosition(startPosition.rightShift(value.length()));
            stringTemplateNode.addChild((Node)stringNode);
        }
        return stringTemplateNode;
    }
}

