/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.phase;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashSet;
import java.util.List;
import javax.annotation.Nullable;
import javax.xml.transform.sax.SAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.commons.lang.StringUtils;
import org.apache.ws.commons.schema.XmlSchema;
import org.raml.v2.api.loader.ResourceLoader;
import org.raml.v2.internal.impl.commons.model.factory.TypeDeclarationModelFactory;
import org.raml.v2.internal.impl.commons.nodes.ExampleDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.type.JsonSchemaExternalType;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.XmlSchemaExternalType;
import org.raml.v2.internal.impl.v10.type.AnyResolvedType;
import org.raml.v2.internal.impl.v10.type.ArrayResolvedType;
import org.raml.v2.internal.impl.v10.type.FileResolvedType;
import org.raml.v2.internal.impl.v10.type.ObjectResolvedType;
import org.raml.v2.internal.impl.v10.type.StringResolvedType;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.v2.internal.impl.v10.type.TypeToXmlSchemaVisitor;
import org.raml.v2.internal.impl.v10.type.UnionResolvedType;
import org.raml.v2.internal.utils.xml.XMLLocalConstants;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.NullValueRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.NodeType;
import org.raml.yagi.framework.nodes.NullNodeImpl;
import org.raml.yagi.framework.nodes.StringNode;
import org.raml.yagi.framework.nodes.StringNodeImpl;
import org.raml.yagi.framework.nodes.jackson.JNodeParser;
import org.raml.yagi.framework.nodes.snakeyaml.NodeParser;
import org.raml.yagi.framework.phase.Phase;
import org.raml.yagi.framework.util.NodeUtils;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class ExampleValidationPhase
implements Phase {
    private ResourceLoader resourceLoader;
    private static final String ERROR_MESSAGE_MAX_LENGTH = "raml.error_message_max_length";
    public static int errorMessageMaxLength = Integer.parseInt(System.getProperty("raml.error_message_max_length", "10000"));
    private static final String NILLABLE_TYPES_PROP = "org.raml.nillable_types";
    public static boolean NILLABLE_TYPES = Boolean.parseBoolean(System.getProperty("org.raml.nillable_types", "false"));

    public ExampleValidationPhase(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }

    public Node apply(Node tree) {
        List descendantsWith = tree.findDescendantsWith(ExampleDeclarationNode.class);
        for (ExampleDeclarationNode exampleTypeNode : descendantsWith) {
            Node validate;
            if (!exampleTypeNode.isStrict().booleanValue()) continue;
            TypeDeclarationNode type = (TypeDeclarationNode)NodeUtils.getAncestor((Node)exampleTypeNode, TypeDeclarationNode.class);
            Node exampleValue = exampleTypeNode.getExampleValue();
            if (type == null || (validate = this.validate(type, exampleValue)) == null) continue;
            exampleValue.replaceWith(validate);
        }
        return tree;
    }

    @Nullable
    public Node validate(TypeDeclarationNode type, String exampleValue) {
        StringNodeImpl exampleValueNode = new StringNodeImpl(exampleValue);
        if (exampleValue == null || StringUtils.isBlank((String)exampleValue) && !(type.getResolvedType() instanceof StringResolvedType)) {
            exampleValueNode = new NullNodeImpl();
        } else if (!(type.getResolvedType() instanceof StringResolvedType || type.getResolvedType() instanceof FileResolvedType || this.isJsonValue(exampleValue) || this.isXmlValue(exampleValue))) {
            exampleValueNode = NodeParser.parse((ResourceLoader)this.resourceLoader, (String)"", (String)exampleValue);
        }
        return this.validate(type, (Node)exampleValueNode);
    }

    @Nullable
    public Node validate(TypeDeclarationNode type, Node exampleValue) {
        ResolvedType resolvedType = type.getResolvedType();
        if (resolvedType instanceof AnyResolvedType) {
            return null;
        }
        if (exampleValue instanceof StringNode && !this.isExternalSchemaType(resolvedType)) {
            String value = ((StringNode)exampleValue).getValue();
            if (this.mightBeAnObjectType(resolvedType) && this.isXmlValue(value)) {
                return this.validateXml(type, resolvedType, value);
            }
            if ((this.mightBeAnObjectType(resolvedType) || resolvedType instanceof ArrayResolvedType) && this.isJsonValue(value)) {
                return this.validateJson(exampleValue, resolvedType, value);
            }
        }
        if (exampleValue instanceof ErrorNode) {
            return exampleValue;
        }
        if (exampleValue != null) {
            Rule rule = this.visitAppropriately(resolvedType);
            return rule != null ? rule.apply(exampleValue) : null;
        }
        return null;
    }

    private Rule visitAppropriately(ResolvedType resolvedType) {
        if (NILLABLE_TYPES) {
            return new AnyOfRule(new Rule[]{resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader, false)), new NullValueRule()});
        }
        return resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader, false));
    }

    private boolean mightBeAnObjectType(ResolvedType resolvedType) {
        if (resolvedType instanceof ObjectResolvedType) {
            return true;
        }
        return this.unionMightBeAnObject(resolvedType, new HashSet<String>());
    }

    private boolean unionMightBeAnObject(ResolvedType resolvedType, HashSet<String> seenTypes) {
        seenTypes.add(resolvedType.getTypeName());
        if (resolvedType instanceof UnionResolvedType) {
            UnionResolvedType urt = (UnionResolvedType)resolvedType;
            for (ResolvedType type : urt.of()) {
                if (seenTypes.contains(type.getTypeName())) continue;
                return this.unionMightBeAnObject(type, seenTypes);
            }
        }
        return resolvedType instanceof ObjectResolvedType || resolvedType instanceof ArrayResolvedType;
    }

    protected Node validateJson(Node exampleValue, ResolvedType resolvedType, String value) {
        Rule rule = resolvedType.visit(new TypeToRuleVisitor(this.resourceLoader, false));
        Node parse = JNodeParser.parse((ResourceLoader)this.resourceLoader, (String)"", (String)value);
        if (parse.getType() != NodeType.Error) {
            Node apply = rule.apply(parse);
            List errorNodeList = apply.findDescendantsWith(ErrorNode.class);
            if (apply instanceof ErrorNode) {
                errorNodeList.add(0, (ErrorNode)apply);
            }
            if (!errorNodeList.isEmpty()) {
                String errorMessage = "";
                for (ErrorNode errorNode : errorNodeList) {
                    if (errorMessage.length() > errorMessageMaxLength) break;
                    if (errorMessage.isEmpty()) {
                        errorMessage = "- " + errorNode.getErrorMessage();
                        continue;
                    }
                    errorMessage = errorMessage + "\n- " + errorNode.getErrorMessage();
                }
                return ErrorNodeFactory.createInvalidJsonExampleNode((String)errorMessage);
            }
            return exampleValue;
        }
        return parse;
    }

    @Nullable
    protected Node validateXml(TypeDeclarationNode type, ResolvedType resolvedType, String value) {
        TypeToXmlSchemaVisitor typeToXmlSchemaVisitor = new TypeToXmlSchemaVisitor();
        typeToXmlSchemaVisitor.transform(new TypeDeclarationModelFactory().create(type).rootElementName(), resolvedType);
        XmlSchema schema = typeToXmlSchemaVisitor.getSchema();
        StringWriter xsd = new StringWriter();
        schema.write((Writer)xsd);
        try {
            SchemaFactory factory = SchemaFactory.newInstance(XMLLocalConstants.XML_SCHEMA_VERSION);
            Schema schema1 = factory.newSchema(new StreamSource(new StringReader(xsd.toString())));
            Validator validator = schema1.newValidator();
            XMLReader xmlReader = XMLReaderFactory.createXMLReader();
            xmlReader.setFeature("http://apache.org/xml/features/disallow-doctype-decl", XMLLocalConstants.expandEntities == false);
            xmlReader.setFeature("http://xml.org/sax/features/external-general-entities", XMLLocalConstants.externalEntities);
            xmlReader.setFeature("http://xml.org/sax/features/external-parameter-entities", XMLLocalConstants.externalEntities);
            validator.validate(new SAXSource(new NamespaceFilter(xmlReader, TypeToXmlSchemaVisitor.getTargetNamespace(resolvedType)), new InputSource(new StringReader(value))));
        }
        catch (IOException | SAXException e) {
            return ErrorNodeFactory.createInvalidXmlExampleNode((String)e.getMessage());
        }
        return null;
    }

    private boolean isXmlValue(String value) {
        return value.trim().startsWith("<");
    }

    private boolean isJsonValue(String value) {
        return value.trim().startsWith("{") || value.trim().startsWith("[");
    }

    private boolean isExternalSchemaType(ResolvedType resolvedType) {
        return resolvedType instanceof XmlSchemaExternalType || resolvedType instanceof JsonSchemaExternalType;
    }

    private static class NamespaceFilter
    extends XMLFilterImpl {
        String requiredNamespace;

        public NamespaceFilter(XMLReader parent, String requiredNamespace) {
            super(parent);
            this.requiredNamespace = requiredNamespace;
        }

        @Override
        public void startElement(String arg0, String arg1, String arg2, Attributes arg3) throws SAXException {
            if (!arg0.equals(this.requiredNamespace)) {
                arg0 = this.requiredNamespace;
            }
            super.startElement(arg0, arg1, arg2, arg3);
        }
    }
}

