/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.type;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.commons.nodes.TypeExpressionNode;
import org.raml.v2.internal.impl.commons.rule.RamlErrorNodeFactory;
import org.raml.v2.internal.impl.commons.type.ResolvedCustomFacets;
import org.raml.v2.internal.impl.commons.type.ResolvedType;
import org.raml.v2.internal.impl.commons.type.SchemaBasedResolvedType;
import org.raml.v2.internal.impl.v10.grammar.Raml10Grammar;
import org.raml.v2.internal.impl.v10.nodes.PropertyNode;
import org.raml.v2.internal.impl.v10.rules.TypesUtils;
import org.raml.v2.internal.impl.v10.type.PropertyFacets;
import org.raml.v2.internal.impl.v10.type.TypeId;
import org.raml.v2.internal.impl.v10.type.TypeVisitor;
import org.raml.v2.internal.impl.v10.type.XmlFacets;
import org.raml.v2.internal.impl.v10.type.XmlFacetsCapableType;
import org.raml.yagi.framework.grammar.rule.AnyOfRule;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.ErrorNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.util.NodeSelector;

public class ObjectResolvedType
extends XmlFacetsCapableType {
    private Integer minProperties;
    private Integer maxProperties;
    private Boolean additionalProperties;
    private String discriminator;
    private String discriminatorValue;
    private Map<String, PropertyFacets> properties = new LinkedHashMap<String, PropertyFacets>();

    public ObjectResolvedType(TypeExpressionNode declarationNode, XmlFacets xmlFacets, Integer minProperties, Integer maxProperties, Boolean additionalProperties, String discriminator, String discriminatorValue, Map<String, PropertyFacets> properties, ResolvedCustomFacets customFacets) {
        super(declarationNode, xmlFacets, customFacets);
        this.minProperties = minProperties;
        this.maxProperties = maxProperties;
        this.additionalProperties = additionalProperties;
        this.discriminator = discriminator;
        this.discriminatorValue = discriminatorValue;
        this.properties = properties;
    }

    public ObjectResolvedType(TypeExpressionNode from) {
        super(from, new ResolvedCustomFacets("minProperties", "maxProperties", "additionalProperties", "discriminator", "discriminatorValue", "properties"));
    }

    @Override
    protected ObjectResolvedType copy() {
        return new ObjectResolvedType(this.getTypeDeclarationNode(), this.getXmlFacets().copy(), this.minProperties, this.maxProperties, this.additionalProperties, this.discriminator, this.discriminatorValue, new LinkedHashMap<String, PropertyFacets>(this.properties), this.customFacets.copy());
    }

    @Override
    public boolean doAccept(ResolvedType valueType) {
        boolean inheritsFrom = super.doAccept(valueType);
        if (inheritsFrom && valueType instanceof ObjectResolvedType) {
            Map<String, PropertyFacets> properties = this.getProperties();
            for (PropertyFacets myProperty : properties.values()) {
                PropertyFacets matchedProperty = ((ObjectResolvedType)valueType).getProperties().get(myProperty.getName());
                if (matchedProperty != null) {
                    if (myProperty.getValueType().accepts(matchedProperty.getValueType())) continue;
                    return false;
                }
                return false;
            }
        }
        return inheritsFrom;
    }

    @Override
    public ResolvedType overwriteFacets(TypeDeclarationNode from) {
        ObjectResolvedType result = this.copy();
        result.customFacets = this.customFacets.overwriteFacets(from);
        result.setMinProperties(NodeSelector.selectIntValue((String)"minProperties", (Node)from));
        result.setMaxProperties(NodeSelector.selectIntValue((String)"maxProperties", (Node)from));
        result.setAdditionalProperties(NodeSelector.selectBooleanValue((String)"additionalProperties", (Node)from));
        result.setDiscriminator(NodeSelector.selectStringValue((String)"discriminator", (Node)from));
        result.setDiscriminatorValue(NodeSelector.selectStringValue((String)"discriminatorValue", (Node)from));
        Node properties = from.get("properties");
        if (properties != null) {
            List children = properties.getChildren();
            for (Node child : children) {
                if (!(child instanceof PropertyNode)) continue;
                PropertyNode property = (PropertyNode)child;
                String name = property.getName();
                PropertyFacets propertyDefinition = new PropertyFacets(property);
                Map<String, PropertyFacets> resultProperties = result.getProperties();
                if (!resultProperties.containsKey(name)) {
                    resultProperties.put(name, propertyDefinition);
                    continue;
                }
                resultProperties.put(name, resultProperties.get(name).mergeFacets(propertyDefinition));
                if (propertyDefinition.getErrorNode() == null) continue;
                child.replaceWith(propertyDefinition.getErrorNode());
            }
        }
        return this.overwriteFacets(result, from);
    }

    @Override
    public ResolvedType mergeFacets(ResolvedType with) {
        ObjectResolvedType result = this.copy();
        if (with instanceof ObjectResolvedType) {
            result.setMinProperties(((ObjectResolvedType)with).getMinProperties());
            result.setMaxProperties(((ObjectResolvedType)with).getMaxProperties());
            result.setAdditionalProperties(((ObjectResolvedType)with).getAdditionalProperties());
            result.setDiscriminator(((ObjectResolvedType)with).getDiscriminator());
            result.setDiscriminatorValue(((ObjectResolvedType)with).getDiscriminatorValue());
            Map<String, PropertyFacets> properties = ((ObjectResolvedType)with).getProperties();
            for (Map.Entry<String, PropertyFacets> property : properties.entrySet()) {
                if (!this.getProperties().containsKey(property.getKey())) {
                    result.getProperties().put(property.getKey(), property.getValue());
                    continue;
                }
                PropertyFacets propertyDefinition = result.getProperties().get(property.getKey());
                result.getProperties().put(property.getKey(), propertyDefinition.mergeFacets(property.getValue()));
            }
        }
        result.customFacets = result.customFacets.mergeWith(with.customFacets());
        return this.mergeFacets(result, with);
    }

    @Override
    public void validateCanOverwriteWith(TypeDeclarationNode from) {
        this.customFacets.validate(from);
        Raml10Grammar raml10Grammar = new Raml10Grammar();
        AnyOfRule facetRule = new AnyOfRule(new Rule[0]).add((Rule)raml10Grammar.propertiesField()).add((Rule)raml10Grammar.minPropertiesField()).add((Rule)raml10Grammar.maxPropertiesField()).add((Rule)raml10Grammar.additionalPropertiesField()).addAll(this.customFacets.getRules());
        if (from.getParent() instanceof TypeDeclarationField && from.getResolvedType() instanceof ObjectResolvedType) {
            facetRule.add((Rule)raml10Grammar.discriminatorField()).add((Rule)raml10Grammar.discriminatorValueField());
        }
        TypesUtils.validateAllWith((Rule)facetRule, from.getFacets());
        Node properties = from.get("properties");
        if (properties != null) {
            List children = properties.getChildren();
            for (Node child : children) {
                PropertyFacets myProperty;
                PropertyNode property;
                String name;
                if (!(child instanceof PropertyNode) || !this.properties.containsKey(name = (property = (PropertyNode)child).getName()) || (myProperty = this.properties.get(name)).getValueType().accepts(property.getTypeDefinition())) continue;
                property.replaceWith((Node)RamlErrorNodeFactory.createCanNotOverrideProperty(name));
            }
        }
    }

    @Override
    public void validateState() {
        super.validateState();
        ErrorNode errorNode = this.validateFacets();
        if (errorNode != null) {
            this.getTypeDeclarationNode().replaceWith((Node)errorNode);
        }
    }

    public ErrorNode validateFacets() {
        int max;
        int min = this.minProperties != null ? this.minProperties : 0;
        int n = max = this.maxProperties != null ? this.maxProperties : Integer.MAX_VALUE;
        if (max < min) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "maxProperties must be greater than or equal to minProperties");
        }
        for (PropertyFacets propertyFacets : this.properties.values()) {
            if (!(propertyFacets.getValueType() instanceof SchemaBasedResolvedType)) continue;
            return RamlErrorNodeFactory.createPropertyCanNotBeOfSchemaType(propertyFacets.getName());
        }
        if (this.discriminator != null && this.properties.get(this.discriminator) == null) {
            return RamlErrorNodeFactory.createInvalidFacetState(this.getTypeName(), "invalid discriminator value, property '" + this.discriminator + "' does not exist");
        }
        return null;
    }

    @Override
    public <T> T visit(TypeVisitor<T> visitor) {
        return visitor.visitObject(this);
    }

    public Integer getMinProperties() {
        return this.minProperties;
    }

    public void setMinProperties(Integer minProperties) {
        if (minProperties != null) {
            this.minProperties = minProperties;
        }
    }

    public Integer getMaxProperties() {
        return this.maxProperties;
    }

    public void setMaxProperties(Integer maxProperties) {
        if (maxProperties != null) {
            this.maxProperties = maxProperties;
        }
    }

    public Boolean getAdditionalProperties() {
        return this.additionalProperties;
    }

    public void setAdditionalProperties(Boolean additionalProperties) {
        if (additionalProperties != null) {
            this.additionalProperties = additionalProperties;
        }
    }

    public String getDiscriminator() {
        return this.discriminator;
    }

    public void setDiscriminator(String discriminator) {
        if (discriminator != null) {
            this.discriminator = discriminator;
        }
    }

    public String getDiscriminatorValue() {
        return this.discriminatorValue;
    }

    public void setDiscriminatorValue(String discriminatorValue) {
        if (discriminatorValue != null) {
            this.discriminatorValue = discriminatorValue;
        }
    }

    public Map<String, PropertyFacets> getProperties() {
        return this.properties;
    }

    public void setProperties(Map<String, PropertyFacets> properties) {
        if (properties != null && !properties.isEmpty()) {
            this.properties = properties;
        }
    }

    @Override
    @Nullable
    public String getBuiltinTypeName() {
        return TypeId.OBJECT.getType();
    }
}

