/*
 * Decompiled with CFR 0.152.
 */
package org.raml.v2.internal.impl.v10.rules;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationField;
import org.raml.v2.internal.impl.commons.nodes.TypeDeclarationNode;
import org.raml.v2.internal.impl.v10.nodes.LibraryLinkNode;
import org.raml.v2.internal.impl.v10.type.TypeToRuleVisitor;
import org.raml.yagi.framework.grammar.rule.ErrorNodeFactory;
import org.raml.yagi.framework.grammar.rule.Rule;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.suggester.ParsingContext;
import org.raml.yagi.framework.suggester.Suggestion;

public class DiscriminatorBasedRule
extends Rule {
    private TypeToRuleVisitor typeToRuleVisitor;
    private Node rootElement;
    private String discriminatorProperty;
    private Map<String, Rule> typeRulesCache;

    public DiscriminatorBasedRule(TypeToRuleVisitor typeToRuleVisitor, Node rootElement, String discriminatorProperty) {
        this.typeToRuleVisitor = typeToRuleVisitor;
        this.rootElement = rootElement;
        this.discriminatorProperty = discriminatorProperty;
        this.typeRulesCache = new HashMap<String, Rule>();
    }

    public boolean matches(@Nonnull Node node) {
        Node discriminatorNode = node.get(this.discriminatorProperty);
        return discriminatorNode instanceof SimpleTypeNode;
    }

    @Nonnull
    public Node apply(@Nonnull Node node) {
        SimpleTypeNode discriminatorValue = (SimpleTypeNode)node.get(this.discriminatorProperty);
        if (discriminatorValue == null) {
            node.replaceWith((Node)ErrorNodeFactory.createInvalidType((String)"discriminator not specified"));
        } else {
            String literalValue = discriminatorValue.getLiteralValue();
            Rule value = this.findType(literalValue);
            if (value != null) {
                value.apply(node);
            } else {
                node.replaceWith((Node)ErrorNodeFactory.createInvalidType((String)literalValue));
            }
        }
        return node;
    }

    @Nullable
    protected Rule findType(String literalValue) {
        Rule value = null;
        if (!this.typeRulesCache.containsKey(literalValue)) {
            TypeDeclarationNode typeDeclaration = this.findTypeDeclaration(literalValue);
            if (typeDeclaration != null) {
                this.typeToRuleVisitor.resolveDiscrimintor();
                value = this.typeToRuleVisitor.generateRule(typeDeclaration.getResolvedType());
                this.typeRulesCache.put(literalValue, value);
            }
        } else {
            value = this.typeRulesCache.get(literalValue);
        }
        return value;
    }

    @Nullable
    protected TypeDeclarationNode findTypeDeclaration(String literalValue) {
        List<TypeDeclarationField> descendantsWith = this.findTypeDeclarationField(this.rootElement);
        for (TypeDeclarationField typeDeclarationField : descendantsWith) {
            Node typeDeclaration = typeDeclarationField.getValue();
            Node discriminatorValue = typeDeclaration.get("discriminatorValue");
            String typeIdentifier = discriminatorValue instanceof SimpleTypeNode ? ((SimpleTypeNode)discriminatorValue).getLiteralValue() : ((SimpleTypeNode)typeDeclarationField.getKey()).getLiteralValue();
            if (!literalValue.equals(typeIdentifier)) continue;
            return (TypeDeclarationNode)typeDeclaration;
        }
        return null;
    }

    @Nonnull
    public List<TypeDeclarationField> findTypeDeclarationField(Node node) {
        ArrayList<TypeDeclarationField> result = new ArrayList<TypeDeclarationField>();
        List children = node.getChildren();
        for (Node child : children) {
            if (child instanceof TypeDeclarationField) {
                result.add((TypeDeclarationField)child);
            } else if (child instanceof LibraryLinkNode) {
                result.addAll(this.findTypeDeclarationField(((LibraryLinkNode)child).getRefNode()));
            }
            result.addAll(this.findTypeDeclarationField(child));
        }
        return result;
    }

    public String getDescription() {
        return "Dynamic rule based on '" + this.discriminatorProperty + "'.";
    }

    @Nonnull
    public List<Suggestion> getSuggestions(Node node, ParsingContext context) {
        return Collections.emptyList();
    }
}

