/*
 * Decompiled with CFR 0.152.
 */
package org.raml.query;

import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import java.io.File;
import org.raml.parsertools.Augmenter;
import org.raml.query.QueryBase;
import org.raml.query.Selector;
import org.raml.query.Selectors;
import org.raml.query.internal.ApiQueryBase;
import org.raml.query.internal.ResourceQueryBase;
import org.raml.v2.api.RamlModelBuilder;
import org.raml.v2.api.RamlModelResult;
import org.raml.v2.api.model.common.ValidationResult;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.v2.api.model.v10.resources.Resource;

public class Query {
    private QueryBase queryBase;

    public Query(QueryBase queryBase) {
        this.queryBase = queryBase;
    }

    public static Query from(Api api) {
        return new Query((QueryBase)Augmenter.augment(ApiQueryBase.class, (Object)api));
    }

    public static Query from(Resource resource) {
        return new Query((QueryBase)Augmenter.augment(ResourceQueryBase.class, (Object)resource));
    }

    public <T> FluentIterable<T> select(Selector<T> selector) {
        return this.queryBase.queryFor(selector);
    }

    public static void main(String[] args) {
        RamlModelResult ramlModelResult = new RamlModelBuilder().buildApi(new File(Query.class.getResource("/api.raml").getFile()));
        if (ramlModelResult.hasErrors()) {
            for (ValidationResult validationResult : ramlModelResult.getValidationResults()) {
                System.out.println(validationResult.getMessage());
            }
        } else {
            Api api = ramlModelResult.getApiV10();
            ImmutableList tr = Query.from(api).select(Selectors.allResources()).toList();
            for (Resource resource : tr) {
                System.err.println(resource.resourcePath());
            }
        }
    }
}

