/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parsertools;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.raml.parsertools.AugmentationException;
import org.raml.parsertools.AugmentationExtensionFactory;
import org.raml.parsertools.Extension;
import org.raml.parsertools.ExtensionFactory;

public class Augmenter {
    public static <T> T augment(Class<T> augmentedInterface, Object delegate) {
        try {
            Extension extension = augmentedInterface.getAnnotation(Extension.class);
            ExtensionFactory extensionFactory = augmentedInterface.getAnnotation(ExtensionFactory.class);
            if (extension == null && extensionFactory == null) {
                throw new IllegalArgumentException("no @Extension or @ExtensionFactory annotation to build augmented interface");
            }
            AugmentationExtensionFactory factory = Augmenter.createFactory(extension, extensionFactory);
            Object handler = Augmenter.findFactoryMethod(delegate, factory);
            return Augmenter.buildProxy(augmentedInterface, delegate, handler);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new AugmentationException("trying to augment " + augmentedInterface, e);
        }
    }

    private static <T> T buildProxy(Class<T> augmentedInterface, final Object delegate, final Object handler) {
        return (T)Proxy.newProxyInstance(Augmenter.class.getClassLoader(), new Class[]{augmentedInterface}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                try {
                    Method handlerMethod = handler.getClass().getDeclaredMethod(method.getName(), method.getParameterTypes());
                    return handlerMethod.invoke(handler, args);
                }
                catch (NoSuchMethodException e) {
                    return method.invoke(delegate, args);
                }
            }
        });
    }

    private static AugmentationExtensionFactory createFactory(Extension extension, ExtensionFactory extensionFactory) throws InstantiationException, IllegalAccessException {
        AugmentationExtensionFactory factory = extensionFactory == null ? new SingleClassFactory(extension.handler()) : extensionFactory.factory().newInstance();
        return factory;
    }

    private static Set<Class<?>> findAllImplementedInterfaces(Class<?> bottomClass) {
        LinkedHashSet classes = new LinkedHashSet(Arrays.asList(bottomClass.getInterfaces()));
        HashSet newClasses = new HashSet();
        for (Class clazz : classes) {
            Set<Class<?>> higherClasses = Augmenter.findAllImplementedInterfaces(clazz);
            newClasses.addAll(higherClasses);
        }
        if (bottomClass.getSuperclass() != null) {
            newClasses.addAll(Augmenter.findAllImplementedInterfaces(bottomClass.getSuperclass()));
        }
        classes.addAll(newClasses);
        return classes;
    }

    private static Object findFactoryMethod(Object delegate, AugmentationExtensionFactory factory) throws NoSuchMethodException, InvocationTargetException, IllegalAccessException {
        Set<Class<?>> classes = Augmenter.findAllImplementedInterfaces(delegate.getClass());
        for (Class<?> aClass : classes) {
            try {
                return factory.getClass().getDeclaredMethod("create", aClass).invoke((Object)factory, delegate);
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
        }
        return factory.create(delegate);
    }

    private static class SingleClassFactory
    implements AugmentationExtensionFactory {
        private final Class<?> handlerClass;

        public SingleClassFactory(Class<?> cls) {
            this.handlerClass = cls;
        }

        @Override
        public Object create(Object delegate) throws AugmentationException {
            try {
                Constructor<?> c = this.handlerClass.getConstructor(delegate.getClass().getInterfaces()[0]);
                Object handler = c.newInstance(delegate);
                return handler;
            }
            catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
                throw new AugmentationException(e);
            }
        }
    }
}

