/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.raml.model.ActionType;
import org.raml.model.DocumentationItem;
import org.raml.model.Resource;
import org.raml.model.Trait;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.resolver.ResourceHandler;
import org.raml.parser.rule.BaseUriRule;
import org.raml.parser.rule.UriParametersRule;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Raml {
    @Scalar(required=true)
    private String title;
    @Scalar
    private String version;
    @Scalar(rule=BaseUriRule.class)
    private String baseUri;
    @Mapping(rule=UriParametersRule.class)
    private Map<String, UriParameter> uriParameters = new HashMap<String, UriParameter>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    @Sequence
    private List<DocumentationItem> documentation;
    @Mapping
    private Map<String, Trait> traits = new HashMap<String, Trait>();

    public void setDocumentation(List<DocumentationItem> documentation) {
        this.documentation = documentation;
    }

    public List<DocumentationItem> getDocumentation() {
        return this.documentation;
    }

    public void setUriParameters(Map<String, UriParameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public void setBaseUri(String baseUri) {
        this.baseUri = baseUri;
    }

    public String getBasePath() {
        try {
            URL url = new URL(this.baseUri);
            return url.getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    public String getUri() {
        return "";
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.uriParameters;
    }

    public Map<String, Trait> getTraits() {
        return this.traits;
    }

    public void setTraits(Map<String, Trait> traits) {
        this.traits = traits;
    }

    public Resource getResource(String path) {
        String baseUriPath;
        if (path.startsWith(this.baseUri)) {
            path = path.substring(this.baseUri.length());
        }
        try {
            baseUriPath = new URL(this.baseUri).getPath();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
        if (path.startsWith(baseUriPath)) {
            path = path.substring(baseUriPath.length());
        }
        for (Resource resource : this.resources.values()) {
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/') continue;
            return resource.getResource(path.substring(resource.getRelativeUri().length()));
        }
        return null;
    }

    public void applyTraits() {
        this.applyTraits(this.getResources().values());
    }

    public void applyTraits(Collection<Resource> resources) {
        for (Resource resource : resources) {
            HashSet<ActionType> finalActions = new HashSet<ActionType>();
            finalActions.addAll(resource.getActions().keySet());
            for (Trait trait : this.getTraits().values()) {
                for (String tActionType : trait.getProvides().keySet()) {
                    if (tActionType.endsWith("?")) continue;
                    finalActions.add(ActionType.valueOf(tActionType.toUpperCase()));
                }
            }
            ArrayList<String> reversed = new ArrayList<String>(resource.getUse());
            Collections.reverse(reversed);
            for (String traitKey : reversed) {
                Trait trait = this.getTraits().get(traitKey);
                trait.applyToResource(resource, finalActions);
            }
            this.applyTraits(resource.getResources().values());
        }
    }
}

