/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Stack;
import org.raml.model.Raml;
import org.raml.parser.builder.DefaultTupleBuilder;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.builder.SequenceBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.DumperOptions;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.emitter.Emitter;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;
import org.yaml.snakeyaml.resolver.Resolver;
import org.yaml.snakeyaml.serializer.Serializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class YamlDocumentBuilder<T>
implements NodeHandler {
    private Class<T> documentClass;
    private T documentObject;
    private Stack<NodeBuilder<?>> builderContext = new Stack();
    private Stack<Object> documentContext = new Stack();
    private MappingNode rootNode;
    private ResourceLoader resourceLoader;

    public YamlDocumentBuilder(Class<T> documentClass) {
        this(documentClass, new DefaultResourceLoader());
    }

    public YamlDocumentBuilder(Class<T> documentClass, ResourceLoader resourceLoader) {
        this.documentClass = documentClass;
        this.resourceLoader = resourceLoader;
    }

    public T build(Reader content) {
        Yaml yamlParser = new Yaml();
        NodeVisitor nodeVisitor = new NodeVisitor(this, this.resourceLoader);
        this.rootNode = (MappingNode)yamlParser.compose(content);
        nodeVisitor.visitDocument(this.rootNode);
        this.postBuildProcess();
        return this.documentObject;
    }

    private void postBuildProcess() {
        if (this.documentObject instanceof Raml) {
            ((Raml)this.documentObject).applyTraits();
        }
    }

    public T build(InputStream content) {
        return this.build(new InputStreamReader(content));
    }

    public T build(String content) {
        return this.build(new StringReader(content));
    }

    public MappingNode getRootNode() {
        return this.rootNode;
    }

    @Override
    public void onMappingNodeStart(MappingNode mappingNode) {
        NodeBuilder<?> currentBuilder = this.builderContext.peek();
        Object parentObject = this.documentContext.peek();
        Object object = ((TupleBuilder)currentBuilder).buildValue(parentObject, mappingNode);
        this.documentContext.push(object);
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode) {
        this.documentContext.pop();
    }

    @Override
    public void onSequenceStart(SequenceNode node, TupleType tupleType) {
        SequenceBuilder currentBuilder = (SequenceBuilder)((Object)this.builderContext.peek());
        Object parentObject = this.documentContext.peek();
        switch (tupleType) {
            case VALUE: {
                Object object = ((NodeBuilder)((Object)currentBuilder)).buildValue(parentObject, node);
                this.builderContext.push(currentBuilder.getItemBuilder());
                this.documentContext.push(object);
            }
        }
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
        this.documentContext.pop();
        this.builderContext.pop();
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        NodeBuilder<?> currentBuilder = this.builderContext.peek();
        Object parentObject = this.documentContext.peek();
        switch (tupleType) {
            case VALUE: {
                currentBuilder.buildValue(parentObject, node);
                break;
            }
            default: {
                ((TupleBuilder)currentBuilder).buildKey(parentObject, node);
            }
        }
    }

    @Override
    public void onDocumentStart(MappingNode node) {
        try {
            this.documentContext.push(this.documentClass.newInstance());
            this.builderContext.push(this.buildDocumentBuilder());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private TupleBuilder<?, ?> buildDocumentBuilder() {
        DefaultTupleBuilder documentBuilder = new DefaultTupleBuilder(new DefaultTupleHandler());
        documentBuilder.addBuildersFor(this.documentClass);
        return documentBuilder;
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
        this.documentObject = this.documentContext.pop();
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        this.builderContext.pop();
    }

    @Override
    public void onTupleStart(NodeTuple nodeTuple) {
        TupleBuilder currentBuilder = (TupleBuilder)this.builderContext.peek();
        if (currentBuilder == null) {
            throw new IllegalStateException("Unexpected builderContext state");
        }
        NodeBuilder builder = currentBuilder.getBuiderForTuple(nodeTuple);
        this.builderContext.push(builder);
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
    }

    @Override
    public void onIncludeResourceNotFound(ScalarNode node) {
        throw new RuntimeException("resource not found: " + node.getValue());
    }

    public static String dumpFromAst(Node rootNode) {
        StringWriter writer = new StringWriter();
        YamlDocumentBuilder.dumpFromAst(rootNode, writer);
        return ((Object)writer).toString();
    }

    public static void dumpFromAst(Node rootNode, Writer output) {
        if (rootNode == null) {
            throw new IllegalArgumentException("rootNode is null");
        }
        DumperOptions dumperOptions = new DumperOptions();
        Tag rootTag = dumperOptions.getExplicitRoot();
        Serializer serializer = new Serializer(new Emitter(output, dumperOptions), new Resolver(), dumperOptions, rootTag);
        try {
            serializer.open();
            serializer.serialize(rootNode);
            serializer.close();
        }
        catch (IOException e) {
            throw new YAMLException(e);
        }
    }
}

