/*
 * Decompiled with CFR 0.152.
 */
package org.raml.model;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.raml.model.Action;
import org.raml.model.ActionType;
import org.raml.model.parameter.UriParameter;
import org.raml.parser.annotation.Key;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Parent;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.resolver.ResourceHandler;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Resource {
    @Scalar
    private String name;
    @Parent(property="uri")
    private String parentUri;
    @Key
    private String relativeUri;
    @Mapping
    private Map<String, UriParameter> uriParameters = new HashMap<String, UriParameter>();
    @Mapping(handler=ResourceHandler.class, implicit=true)
    private Map<String, Resource> resources = new HashMap<String, Resource>();
    @Mapping(implicit=true)
    private Map<ActionType, Action> actions = new HashMap<ActionType, Action>();
    @Sequence
    private List<String> use = new ArrayList<String>();

    public void setRelativeUri(String relativeUri) {
        this.relativeUri = relativeUri;
    }

    public String getParentUri() {
        return this.parentUri;
    }

    public void setParentUri(String parentUri) {
        this.parentUri = parentUri;
    }

    public void setUriParameters(Map<String, UriParameter> uriParameters) {
        this.uriParameters = uriParameters;
    }

    public Map<ActionType, Action> getActions() {
        return this.actions;
    }

    public void setActions(Map<ActionType, Action> actions) {
        this.actions = actions;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public String getRelativeUri() {
        return this.relativeUri;
    }

    public String getUri() {
        if (this.parentUri.endsWith("/")) {
            return this.parentUri + this.relativeUri.substring(1);
        }
        return this.parentUri + this.relativeUri;
    }

    public Action getAction(ActionType name) {
        return this.actions.get((Object)name);
    }

    public Action getAction(String name) {
        return this.actions.get((Object)ActionType.valueOf(name.toUpperCase()));
    }

    public Map<String, Resource> getResources() {
        return this.resources;
    }

    public void setResources(Map<String, Resource> resources) {
        this.resources = resources;
    }

    public Map<String, UriParameter> getUriParameters() {
        return this.uriParameters;
    }

    public List<String> getUse() {
        return this.use;
    }

    public void setUse(List<String> use) {
        this.use = use;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Resource)) {
            return false;
        }
        Resource resource = (Resource)o;
        return this.parentUri.equals(resource.parentUri) && this.relativeUri.equals(resource.relativeUri);
    }

    public int hashCode() {
        int result = this.parentUri.hashCode();
        result = 31 * result + this.relativeUri.hashCode();
        return result;
    }

    public String toString() {
        return "Resource{name='" + this.name + '\'' + ", uri='" + this.getUri() + '\'' + '}';
    }

    public Resource getResource(String path) {
        for (Resource resource : this.resources.values()) {
            if (!path.startsWith(resource.getRelativeUri())) continue;
            if (path.length() == resource.getRelativeUri().length()) {
                return resource;
            }
            if (path.charAt(resource.getRelativeUri().length()) != '/') continue;
            return resource.getResource(path.substring(resource.getRelativeUri().length()));
        }
        return null;
    }
}

