/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.util.ArrayList;
import java.util.List;
import org.raml.parser.resolver.DefaultScalarTupleHandler;
import org.raml.parser.resolver.DefaultTupleHandler;
import org.raml.parser.rule.BaseUriRule;
import org.raml.parser.rule.DefaultTupleRule;
import org.raml.parser.rule.ParamRule;
import org.raml.parser.rule.TupleRule;
import org.raml.parser.rule.ValidationMessage;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UriParametersRule
extends DefaultTupleRule<ScalarNode, MappingNode> {
    private List<ValidationResult> errors = new ArrayList<ValidationResult>();
    private ScalarNode keyNode;

    public UriParametersRule() {
        super("baseUriParameters", new DefaultScalarTupleHandler("baseUriParameters"));
    }

    @Override
    public List<ValidationResult> onRuleEnd() {
        return this.errors;
    }

    @Override
    public List<ValidationResult> validateKey(ScalarNode key) {
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>();
        if (this.wasAlreadyDefined()) {
            validationResults.add(ValidationResult.createErrorResult(ValidationMessage.getDuplicateRuleMessage("uriParameters"), (Node)key));
        }
        validationResults.addAll(super.validateKey(key));
        if (ValidationResult.areValid(validationResults)) {
            this.setKeyNode(key);
        }
        return validationResults;
    }

    @Override
    public TupleRule<?, ?> getRuleForTuple(NodeTuple nodeTuple) {
        Node keyNode = nodeTuple.getKeyNode();
        if (keyNode instanceof ScalarNode) {
            String paramName = ((ScalarNode)keyNode).getValue();
            if (paramName.equals("version")) {
                this.errors.add(ValidationResult.createErrorResult("'" + paramName + "'" + " can not be declared, it is a reserved URI parameter.", keyNode));
            } else {
                if (this.getUriRule().getParameters().contains(paramName)) {
                    return new ParamRule(paramName, this.getNodeRuleFactory());
                }
                this.errors.add(ValidationResult.createErrorResult("Parameter '" + paramName + "' not declared in baseUri", keyNode));
            }
        } else {
            this.errors.add(ValidationResult.createErrorResult("Invalid element", keyNode));
        }
        return new DefaultTupleRule(keyNode.toString(), new DefaultTupleHandler(), this.getNodeRuleFactory());
    }

    public boolean wasAlreadyDefined() {
        return this.keyNode != null;
    }

    public void setKeyNode(ScalarNode rulePresent) {
        this.keyNode = rulePresent;
    }

    public BaseUriRule getUriRule() {
        return (BaseUriRule)this.getRootTupleRule().getRuleByFieldName("baseUri");
    }
}

