/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.rule;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.raml.parser.rule.SimpleRule;
import org.raml.parser.rule.ValidationResult;
import org.yaml.snakeyaml.nodes.ScalarNode;

public class BaseUriRule
extends SimpleRule {
    public static final String URI_NOT_VALID_MESSAGE = "The baseUri element is not a valid URI";
    public static final String VERSION_NOT_PRESENT_MESSAGE = "version parameter must exist in the API definition";
    public static final String URI_PATTERN = "[.*]?\\{(\\w+)?\\}[.*]*";
    private String baseUri;
    private Set<String> parameters = new HashSet<String>();
    private Pattern pattern = Pattern.compile("[.*]?\\{(\\w+)?\\}[.*]*");

    public BaseUriRule() {
        super("baseUri", String.class);
    }

    public String getBaseUri() {
        return this.baseUri;
    }

    public Set<String> getParameters() {
        return this.parameters;
    }

    @Override
    public List<ValidationResult> doValidateValue(ScalarNode node) {
        String value = node.getValue();
        Matcher matcher = this.pattern.matcher(value);
        ArrayList<ValidationResult> validationResults = new ArrayList<ValidationResult>(super.doValidateValue(node));
        while (matcher.find()) {
            String paramValue = matcher.group(1);
            value = value.replace("{" + paramValue + "}", "temp");
            this.parameters.add(paramValue);
        }
        if (this.getVersionRule().getKeyNode() == null && this.parameters.contains(this.getVersionRule().getName())) {
            validationResults.add(ValidationResult.createErrorResult(VERSION_NOT_PRESENT_MESSAGE, node.getStartMark(), node.getEndMark()));
        }
        if (this.parameters.isEmpty() && !this.isValid(value)) {
            validationResults.add(ValidationResult.createErrorResult(URI_NOT_VALID_MESSAGE, this.getKeyNode().getStartMark(), this.getKeyNode().getEndMark()));
        }
        if (ValidationResult.areValid(validationResults)) {
            this.baseUri = node.getValue();
        }
        return validationResults;
    }

    private boolean isValid(String value) {
        try {
            new URL(value);
            return true;
        }
        catch (MalformedURLException e) {
            return false;
        }
    }

    public SimpleRule getVersionRule() {
        return (SimpleRule)this.getParentTupleRule().getRuleByFieldName("version");
    }
}

