/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.lang.reflect.Field;
import java.util.regex.Pattern;
import org.yaml.snakeyaml.resolver.Resolver;

public class ReflectionFieldsOverride {
    private final Pattern originalFloatPattern = Pattern.compile("^([-+]?(\\.[0-9]+|[0-9_]+(\\.[0-9_]*)?)([eE][-+]?[0-9]+)?|[-+]?[0-9][0-9_]*(?::[0-5]?[0-9])+\\.[0-9_]*|[-+]?\\.(?:inf|Inf|INF)|\\.(?:nan|NaN|NAN))$");
    private final Pattern originalIntPattern = Pattern.compile("^(?:[-+]?0b[0-1_]+|[-+]?0[0-7_]+|[-+]?(?:0|[1-9][0-9_]*)|[-+]?0x[0-9a-fA-F_]+|[-+]?[1-9][0-9_]*(?::[0-5]?[0-9])+)$");

    public void overrideSnakeYAMLPatterns() {
        try {
            Class<Resolver> resolverClass = Resolver.class;
            Field floatPatternField = resolverClass.getDeclaredField("FLOAT");
            Field integerPatternField = resolverClass.getDeclaredField("INT");
            this.setFinalStatic(floatPatternField, this.originalFloatPattern);
            this.setFinalStatic(integerPatternField, this.originalIntPattern);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setFinalStatic(Field field, Object newValue) throws Exception {
        field.setAccessible(true);
        Field modifiersField = Field.class.getDeclaredField("modifiers");
        modifiersField.setAccessible(true);
        modifiersField.setInt(field, field.getModifiers() & 0xFFFFFFEF);
        field.set(null, newValue);
    }
}

