/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.raml.parser.CustomYaml;
import org.raml.parser.builder.NodeBuilder;
import org.raml.parser.builder.TupleBuilder;
import org.raml.parser.completion.DefaultSuggestion;
import org.raml.parser.completion.NodeContext;
import org.raml.parser.completion.Suggestion;
import org.raml.parser.loader.DefaultResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.NodeVisitor;
import org.raml.parser.visitor.TupleType;
import org.raml.parser.visitor.YamlDocumentBuilder;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class YamlDocumentSuggester
implements NodeHandler {
    private YamlDocumentBuilder builder;
    private int offset;
    private Stack<NodeContext> nodes;

    public YamlDocumentSuggester(YamlDocumentBuilder builder) {
        this.builder = builder;
        this.nodes = new Stack();
    }

    public List<Suggestion> suggest(String topSection, String context) {
        return this.suggest(topSection, context, null);
    }

    public List<Suggestion> suggest(String topSection, String context, String bottomSection) {
        ArrayList<Suggestion> result = new ArrayList<Suggestion>();
        int contextColumn = this.calculateContextColumn(context);
        String suggestRaml = this.digestSuggestRaml(topSection, bottomSection, contextColumn);
        this.offset = suggestRaml.length();
        if (this.offset == 0) {
            result.add(new DefaultSuggestion("#%RAML 0.8", 0));
            return result;
        }
        CustomYaml yamlParser = new CustomYaml();
        NodeVisitor nodeVisitor = new NodeVisitor(this, new DefaultResourceLoader(), new TagResolver[0]);
        MappingNode rootNode = null;
        Node compose = yamlParser.compose(new StringReader(suggestRaml));
        if (compose != null && compose.getNodeId() == NodeId.mapping) {
            rootNode = (MappingNode)compose;
        }
        nodeVisitor.visitDocument(rootNode);
        NodeBuilder<?> parentNodeBuilder = null;
        NodeContext nodeContext = this.nodes.peek();
        while (!this.nodes.isEmpty()) {
            nodeContext = this.popNode();
            parentNodeBuilder = this.builder.getBuilderContext().pop();
            if (nodeContext.getParentIndentation() >= contextColumn) continue;
        }
        if (!this.isContextInValue(context)) {
            this.addKeySuggestions(context, result, parentNodeBuilder, nodeContext);
        }
        Collections.sort(result);
        return result;
    }

    private String digestSuggestRaml(String topSection, String bottomSection, int contextColumn) {
        if (bottomSection == null) {
            return this.trimTrailingComments(topSection);
        }
        String bottom = this.digestBottomSection(bottomSection, contextColumn);
        return this.trimTrailingComments(topSection + "\n" + bottom);
    }

    private String trimTrailingComments(String raml) {
        int index;
        String[] lines = raml.split("\n");
        Pattern blankOrComment = Pattern.compile("\\s*(#.*)?");
        for (index = lines.length - 1; index > 0 && blankOrComment.matcher(lines[index]).matches(); --index) {
        }
        if (index > 0) {
            lines[index] = lines[index].replaceFirst(" #.*", "");
        }
        StringBuilder result = new StringBuilder();
        for (int i = 0; i <= index; ++i) {
            result.append(lines[i]).append("\n");
        }
        return result.toString().trim();
    }

    private String digestBottomSection(String bottomSection, int contextColumn) {
        Pattern sameContext;
        Pattern parentContext = null;
        if (contextColumn > 0) {
            sameContext = Pattern.compile("[ ]{" + contextColumn + ",}\\S+.*");
            parentContext = Pattern.compile("[ ]{0," + (contextColumn - 1) + "}\\S+.*");
        } else if (contextColumn == 0) {
            sameContext = Pattern.compile("\\S+.*");
        } else {
            throw new IllegalArgumentException("invalid column context: " + contextColumn);
        }
        StringBuilder buffer = new StringBuilder(bottomSection.length());
        for (String line : bottomSection.split("\n")) {
            if (sameContext.matcher(line).matches()) {
                buffer.append(line).append("\n");
                continue;
            }
            if (parentContext != null && parentContext.matcher(line).matches()) break;
        }
        return buffer.toString();
    }

    private void addKeySuggestions(String context, List<Suggestion> result, NodeBuilder<?> parent, NodeContext nodeContext) {
        if (parent instanceof TupleBuilder) {
            List<String> existingKeys = nodeContext.getKeys();
            Collection<TupleBuilder<?, ?>> childrenTupleBuilders = ((TupleBuilder)parent).getChildrenTupleBuilders();
            for (TupleBuilder<?, ?> childTupleBuilder : childrenTupleBuilders) {
                List<Suggestion> suggestions = childTupleBuilder.getHandler().getSuggestions();
                String contextTrimmed = context.trim();
                for (Suggestion suggestion : suggestions) {
                    if (!suggestion.getLabel().startsWith(contextTrimmed) || existingKeys.contains(suggestion.getLabel())) continue;
                    suggestion.setIndentation(nodeContext.getSiblingsIndentation());
                    result.add(suggestion);
                }
            }
        }
    }

    private boolean isContextInValue(String context) {
        return context.contains(":");
    }

    private int calculateContextColumn(String context) {
        int column;
        for (column = 0; column < context.length() && StringUtils.isWhitespace((String)(context.charAt(column) + "")); ++column) {
        }
        return column;
    }

    private void pushNode(Node node, MappingNode mappingNode) {
        this.pushNode(node.getStartMark().getColumn(), mappingNode);
    }

    private void pushNode(int column, MappingNode mappingNode) {
        this.nodes.push(new NodeContext(column, mappingNode));
    }

    private NodeContext popNode() {
        return this.nodes.pop();
    }

    @Override
    public boolean onMappingNodeStart(MappingNode mappingNode, TupleType tupleType) {
        return this.builder.onMappingNodeStart(mappingNode, tupleType);
    }

    @Override
    public void onMappingNodeEnd(MappingNode mappingNode, TupleType tupleType) {
        this.builder.onMappingNodeEnd(mappingNode, tupleType);
    }

    @Override
    public boolean onSequenceStart(SequenceNode node, TupleType tupleType) {
        this.pushNode((Node)node, null);
        return this.builder.onSequenceStart(node, tupleType);
    }

    @Override
    public void onSequenceEnd(SequenceNode node, TupleType tupleType) {
        this.popNode();
        this.builder.onSequenceEnd(node, tupleType);
    }

    @Override
    public void onScalar(ScalarNode node, TupleType tupleType) {
        try {
            this.builder.onScalar(node, tupleType);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Override
    public boolean onDocumentStart(MappingNode node) {
        if (node == null) {
            this.pushNode(0, null);
        } else {
            this.pushNode((Node)node, node);
        }
        return this.builder.onDocumentStart(node);
    }

    @Override
    public void onDocumentEnd(MappingNode node) {
    }

    @Override
    public void onTupleEnd(NodeTuple nodeTuple) {
        Node valueNode = nodeTuple.getValueNode();
        if (this.validateOffset(valueNode)) {
            this.popNode();
            this.builder.onTupleEnd(nodeTuple);
        }
    }

    private boolean validateOffset(Node valueNode) {
        return valueNode != null && valueNode.getEndMark().getIndex() < this.offset;
    }

    @Override
    public boolean onTupleStart(NodeTuple nodeTuple) {
        try {
            this.builder.onTupleStart(nodeTuple);
            MappingNode mapping = nodeTuple.getValueNode().getNodeId() == NodeId.mapping ? (MappingNode)nodeTuple.getValueNode() : null;
            this.pushNode(nodeTuple.getKeyNode(), mapping);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    @Override
    public void onSequenceElementStart(Node sequenceNode) {
        this.builder.onSequenceElementStart(sequenceNode);
    }

    @Override
    public void onSequenceElementEnd(Node sequenceNode) {
        this.builder.onSequenceElementEnd(sequenceNode);
    }

    @Override
    public void onCustomTagStart(Tag tag, Node originalValueNode, Node node) {
        this.builder.onCustomTagStart(tag, originalValueNode, node);
    }

    @Override
    public void onCustomTagEnd(Tag tag, Node originalValueNode, Node node) {
        this.builder.onCustomTagEnd(tag, originalValueNode, node);
    }

    @Override
    public void onCustomTagError(Tag tag, Node node, String message) {
    }
}

