/*
 * Decompiled with CFR 0.152.
 */
package org.raml.parser.visitor;

import java.util.ArrayList;
import java.util.List;
import org.raml.parser.loader.ResourceLoader;
import org.raml.parser.tagresolver.TagResolver;
import org.raml.parser.utils.NodeUtils;
import org.raml.parser.visitor.NodeHandler;
import org.raml.parser.visitor.TupleType;
import org.yaml.snakeyaml.constructor.SafeConstructor;
import org.yaml.snakeyaml.error.YAMLException;
import org.yaml.snakeyaml.nodes.MappingNode;
import org.yaml.snakeyaml.nodes.Node;
import org.yaml.snakeyaml.nodes.NodeId;
import org.yaml.snakeyaml.nodes.NodeTuple;
import org.yaml.snakeyaml.nodes.ScalarNode;
import org.yaml.snakeyaml.nodes.SequenceNode;
import org.yaml.snakeyaml.nodes.Tag;

public class NodeVisitor {
    private NodeHandler nodeHandler;
    private ResourceLoader resourceLoader;
    private TagResolver[] tagResolvers;

    public NodeVisitor(NodeHandler nodeHandler, ResourceLoader resourceLoader, TagResolver ... tagResolvers) {
        this.nodeHandler = nodeHandler;
        this.resourceLoader = resourceLoader;
        this.tagResolvers = tagResolvers;
    }

    private void visitMappingNode(MappingNode mappingNode, TupleType tupleType) {
        this.nodeHandler.onMappingNodeStart(mappingNode);
        this.doVisitMappingNode(mappingNode);
        this.nodeHandler.onMappingNodeEnd(mappingNode);
    }

    private void doVisitMappingNode(MappingNode mappingNode) {
        if (mappingNode.isMerged()) {
            new MappingNodeMerger().merge(mappingNode);
        }
        List tuples = mappingNode.getValue();
        ArrayList<NodeTuple> updatedTuples = new ArrayList<NodeTuple>();
        for (NodeTuple nodeTuple : tuples) {
            Node valueNode;
            Node keyNode = nodeTuple.getKeyNode();
            if (!(keyNode instanceof ScalarNode)) {
                throw new YAMLException("Only scalar keys are allowed: " + keyNode.getStartMark());
            }
            Node originalValueNode = valueNode = nodeTuple.getValueNode();
            Tag tag = valueNode.getTag();
            TagResolver tagResolver = this.getTagResolver(tag);
            if (tagResolver != null) {
                valueNode = tagResolver.resolve(valueNode, this.resourceLoader, this.nodeHandler);
                nodeTuple = new NodeTuple(keyNode, valueNode);
            } else if (!NodeUtils.isStandardTag(tag)) {
                this.nodeHandler.onCustomTagError(tag, valueNode, "Unknown tag " + tag);
            }
            updatedTuples.add(nodeTuple);
            if (tagResolver != null) {
                this.nodeHandler.onCustomTagStart(tag, originalValueNode, nodeTuple);
            }
            this.nodeHandler.onTupleStart(nodeTuple);
            this.visit(keyNode, TupleType.KEY);
            this.visit(valueNode, TupleType.VALUE);
            this.nodeHandler.onTupleEnd(nodeTuple);
            if (tagResolver == null) continue;
            this.nodeHandler.onCustomTagEnd(tag, originalValueNode, nodeTuple);
        }
        mappingNode.setValue(updatedTuples);
    }

    private TagResolver getTagResolver(Tag tag) {
        for (TagResolver resolver : this.tagResolvers) {
            if (!resolver.handles(tag)) continue;
            return resolver;
        }
        return null;
    }

    public void visitDocument(MappingNode node) {
        this.nodeHandler.onDocumentStart(node);
        if (node != null) {
            this.doVisitMappingNode(node);
        }
        this.nodeHandler.onDocumentEnd(node);
    }

    private void visit(Node node, TupleType tupleType) {
        if (node.getNodeId() == NodeId.mapping) {
            this.visitMappingNode((MappingNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.scalar) {
            this.visitScalar((ScalarNode)node, tupleType);
        } else if (node.getNodeId() == NodeId.sequence) {
            this.visitSequence((SequenceNode)node, tupleType);
        }
    }

    private void visitSequence(SequenceNode node, TupleType tupleType) {
        this.nodeHandler.onSequenceStart(node, tupleType);
        List value = node.getValue();
        for (Node sequenceNode : value) {
            this.nodeHandler.onSequenceElementStart(sequenceNode);
            this.visit(sequenceNode, tupleType);
            this.nodeHandler.onSequenceElementEnd(sequenceNode);
        }
        this.nodeHandler.onSequenceEnd(node, tupleType);
    }

    private void visitScalar(ScalarNode node, TupleType tupleType) {
        this.nodeHandler.onScalar(node, tupleType);
    }

    private class MappingNodeMerger
    extends SafeConstructor {
        private MappingNodeMerger() {
        }

        void merge(MappingNode mappingNode) {
            this.flattenMapping(mappingNode);
        }
    }
}

