/*
 * Decompiled with CFR 0.152.
 */
package org.raml.emitter;

import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.raml.model.ParamType;
import org.raml.model.Protocol;
import org.raml.model.Raml;
import org.raml.model.SecurityReference;
import org.raml.model.parameter.AbstractParam;
import org.raml.parser.annotation.Mapping;
import org.raml.parser.annotation.Scalar;
import org.raml.parser.annotation.Sequence;
import org.raml.parser.utils.ReflectionUtils;

public class RamlEmitter {
    public static final String VERSION = "#%RAML 0.8";
    private static final String INDENTATION = "    ";
    private static final String YAML_SEQ = "- ";
    private static final String YAML_SEQ_START = "[";
    private static final String YAML_SEQ_END = "]";
    private static final String YAML_SEQ_SEP = ", ";
    private static final String YAML_MAP_SEP = ": ";
    private static final Pattern NO_QUOTES = Pattern.compile("^[a-zA-Z_/+][^:]*$");
    private static final String[] LITERALS = new String[]{"yes", "no", "true", "false", "on", "off", "null"};

    public String dump(Raml raml) {
        StringBuilder dump = new StringBuilder(VERSION);
        dump.append("\n");
        int depth = 0;
        this.dumpPojo(dump, depth, raml);
        return dump.toString();
    }

    private void dumpPojo(StringBuilder dump, int depth, Object pojo) {
        List<Field> declaredFields = ReflectionUtils.getInheritedFields(pojo.getClass());
        pojo.getClass();
        for (Field declaredField : declaredFields) {
            declaredField.setAccessible(true);
            Scalar scalar = declaredField.getAnnotation(Scalar.class);
            Mapping mapping = declaredField.getAnnotation(Mapping.class);
            Sequence sequence = declaredField.getAnnotation(Sequence.class);
            if (scalar != null) {
                this.dumpScalarField(dump, depth, declaredField, pojo);
                continue;
            }
            if (mapping != null) {
                this.dumpMappingField(dump, depth, declaredField, mapping.implicit(), pojo);
                continue;
            }
            if (sequence == null) continue;
            this.dumpSequenceField(dump, depth, declaredField, pojo);
        }
    }

    private Object getFieldValue(Field field, Object pojo) {
        try {
            return field.get(pojo);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void dumpSequenceField(StringBuilder dump, int depth, Field field, Object pojo) {
        if (!List.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("Only List can be sequence.");
        }
        List seq = (List)this.getFieldValue(field, pojo);
        if (seq == null || seq.size() == 0) {
            return;
        }
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pType = (ParameterizedType)type;
            Type itemType = pType.getActualTypeArguments()[0];
            dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP);
            this.dumpSequenceItems(dump, depth, seq, itemType);
        }
    }

    private void dumpSequenceItems(StringBuilder dump, int depth, List seq, Type itemType) {
        if (itemType instanceof ParameterizedType) {
            this.generateSequenceOfMaps(dump, depth + 1, seq, (ParameterizedType)itemType);
            return;
        }
        if (this.customSequenceHandled(dump, depth + 1, seq, itemType)) {
            return;
        }
        if (ReflectionUtils.isPojo((Class)itemType)) {
            dump.append("\n");
            for (Object item : seq) {
                dump.append(this.indent(depth + 1)).append(YAML_SEQ).append("\n");
                this.dumpPojo(dump, depth + 2, item);
            }
        } else {
            this.generateInlineSequence(dump, seq);
        }
    }

    private boolean customSequenceHandled(StringBuilder dump, int depth, List seq, Type itemType) {
        if (itemType instanceof Class && SecurityReference.class.isAssignableFrom((Class)itemType)) {
            this.handleSecurityReference(dump, depth, seq);
        } else if (itemType instanceof Class && AbstractParam.class.isAssignableFrom((Class)itemType) && seq.size() == 1) {
            this.handleSingleParameterAsNoSeq(dump, depth, seq);
        } else {
            return false;
        }
        return true;
    }

    private void handleSingleParameterAsNoSeq(StringBuilder dump, int depth, List seq) {
        dump.append("\n");
        this.dumpPojo(dump, depth, seq.get(0));
    }

    private void handleSecurityReference(StringBuilder dump, int depth, List seq) {
        dump.append("\n");
        for (Object item : seq) {
            dump.append(this.indent(depth)).append(YAML_SEQ).append("\n");
            dump.append(this.indent(depth + 1)).append(((SecurityReference)item).getName());
            if (((SecurityReference)item).getParameters().size() > 0) {
                dump.append(YAML_MAP_SEP).append("\n");
                this.dumpMap(dump, depth + 2, (Type)((Object)String.class), ((SecurityReference)item).getParameters());
                continue;
            }
            dump.append("\n");
        }
    }

    private void generateSequenceOfMaps(StringBuilder dump, int depth, List seq, ParameterizedType itemType) {
        Type valueType;
        Type rawType = itemType.getRawType();
        if (rawType instanceof Class && Map.class.isAssignableFrom((Class)rawType) && (valueType = itemType.getActualTypeArguments()[1]) instanceof Class) {
            dump.append("\n");
            for (Object item : seq) {
                dump.append(this.indent(depth)).append(YAML_SEQ).append("\n");
                this.dumpMap(dump, depth + 1, valueType, (Map)item);
            }
        }
    }

    private void generateInlineSequence(StringBuilder dump, List seq) {
        dump.append(YAML_SEQ_START);
        for (int i = 0; i < seq.size(); ++i) {
            Object item = seq.get(i);
            dump.append(this.sanitizeScalarValue(0, item));
            if (i >= seq.size() - 1) continue;
            dump.append(YAML_SEQ_SEP);
        }
        dump.append(YAML_SEQ_END).append("\n");
    }

    private void dumpMappingField(StringBuilder dump, int depth, Field field, boolean implicit, Object pojo) {
        if (!Map.class.isAssignableFrom(field.getType())) {
            throw new RuntimeException("invalid type");
        }
        Map value = (Map)this.getFieldValue(field, pojo);
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!implicit) {
            dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP).append("\n");
            ++depth;
        }
        ParameterizedType pType = (ParameterizedType)field.getGenericType();
        Type valueType = pType.getActualTypeArguments()[1];
        this.dumpMap(dump, depth, valueType, value);
    }

    private void dumpMap(StringBuilder dump, int depth, Type valueType, Map value) {
        Type rawType;
        Type listType = null;
        if (valueType instanceof ParameterizedType && (rawType = ((ParameterizedType)valueType).getRawType()) instanceof Class && List.class.isAssignableFrom((Class)rawType)) {
            listType = ((ParameterizedType)valueType).getActualTypeArguments()[0];
        }
        for (Map.Entry entry : value.entrySet()) {
            dump.append(this.indent(depth)).append(this.sanitizeScalarValue(depth, entry.getKey()));
            dump.append(YAML_MAP_SEP);
            if (listType != null) {
                this.dumpSequenceItems(dump, depth, (List)entry.getValue(), listType);
                continue;
            }
            if (ReflectionUtils.isPojo((Class)valueType)) {
                dump.append("\n");
                this.dumpPojo(dump, depth + 1, entry.getValue());
                continue;
            }
            dump.append(this.sanitizeScalarValue(depth + 1, entry.getValue())).append("\n");
        }
    }

    private void dumpScalarField(StringBuilder dump, int depth, Field field, Object pojo) {
        try {
            Object value = field.get(pojo);
            if (value == null) {
                return;
            }
            dump.append(this.indent(depth)).append(this.alias(field)).append(YAML_MAP_SEP);
            if (ReflectionUtils.isPojo(value.getClass())) {
                dump.append("\n");
                this.dumpPojo(dump, depth + 1, value);
            } else if ((this.isNumber(pojo) || this.isInteger(pojo) || this.isBoolean(pojo)) && this.isDefaultValue(field)) {
                dump.append(String.valueOf(value)).append("\n");
            } else {
                dump.append(this.sanitizeScalarValue(depth, value)).append("\n");
            }
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private boolean isDefaultValue(Field field) {
        return field.getName().equals("defaultValue");
    }

    private boolean isNumber(Object pojo) {
        return pojo instanceof AbstractParam && ((AbstractParam)pojo).getType() == ParamType.NUMBER;
    }

    private boolean isInteger(Object pojo) {
        return pojo instanceof AbstractParam && ((AbstractParam)pojo).getType() == ParamType.INTEGER;
    }

    private boolean isBoolean(Object pojo) {
        return pojo instanceof AbstractParam && ((AbstractParam)pojo).getType() == ParamType.BOOLEAN;
    }

    private String alias(Field field) {
        Scalar scalar = field.getAnnotation(Scalar.class);
        Mapping mapping = field.getAnnotation(Mapping.class);
        Sequence sequence = field.getAnnotation(Sequence.class);
        if (scalar != null && StringUtils.isNotEmpty((CharSequence)scalar.alias())) {
            return scalar.alias();
        }
        if (mapping != null && StringUtils.isNotEmpty((CharSequence)mapping.alias())) {
            return mapping.alias();
        }
        if (sequence != null && StringUtils.isNotEmpty((CharSequence)sequence.alias())) {
            return sequence.alias();
        }
        return field.getName();
    }

    private String sanitizeScalarValue(int depth, Object value) {
        String text;
        Class<?> type = value.getClass();
        String result = this.handleCustomScalar(value);
        if (result != null) {
            return result;
        }
        result = ReflectionUtils.isEnum(type) ? String.valueOf(value).toLowerCase() : (String.class.isAssignableFrom(type) ? ((text = (String)value).contains("\n") || text.contains("\\") ? this.blockFormat(depth, text) : this.inlineFormat(depth, text)) : String.valueOf(value));
        return result;
    }

    private String handleCustomScalar(Object value) {
        if (value instanceof Protocol) {
            return String.valueOf(value);
        }
        if (value instanceof BigDecimal) {
            return ((BigDecimal)value).stripTrailingZeros().toString();
        }
        return null;
    }

    private String inlineFormat(int depth, String text) {
        if (!this.requiresQuoting(text)) {
            return text;
        }
        if (!text.contains("\"")) {
            return "\"" + text + "\"";
        }
        if (!text.contains("'")) {
            return "'" + text + "'";
        }
        return this.blockFormat(depth, text);
    }

    private boolean requiresQuoting(String text) {
        return !NO_QUOTES.matcher(text).matches() || this.isReserved(text);
    }

    private boolean isReserved(String text) {
        for (String literal : LITERALS) {
            if (!literal.equalsIgnoreCase(text)) continue;
            return true;
        }
        return false;
    }

    private String blockFormat(int depth, String text) {
        String[] lines;
        String blockPrefix = "|\n";
        if (!text.contains("\n")) {
            blockPrefix = "|-\n";
        }
        StringBuilder block = new StringBuilder(blockPrefix);
        for (String line : lines = text.split("\n")) {
            block.append(this.indent(depth + 1)).append(line).append("\n");
        }
        return block.substring(0, block.length() - 1);
    }

    private String indent(int depth) {
        return StringUtils.repeat((String)INDENTATION, (int)depth);
    }
}

