/*
 * Decompiled with CFR 0.152.
 */
package org.raml.simpleemitter;

import com.google.common.base.Joiner;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.raml.yagi.framework.nodes.SimpleTypeNode;
import org.raml.yagi.framework.nodes.StringNode;

public class YamlEmitter {
    private static final int depth = 4;
    private final Writer writer;
    private final int indent;

    public YamlEmitter() {
        this(new OutputStreamWriter(System.out), 0);
    }

    public YamlEmitter(Writer writer, int i) {
        this.indent = i;
        this.writer = writer;
    }

    public YamlEmitter indent() {
        return new YamlEmitter(this.writer, this.indent + 1);
    }

    public YamlEmitter bulletListArray() {
        return new YamlEmitter(this.writer, this.indent + 1){
            boolean firstwrite;
            {
                this.firstwrite = true;
            }

            @Override
            public void writeTag(String tag) throws IOException {
                if (this.firstwrite) {
                    YamlEmitter.this.writer.write(tag + ": ");
                    this.firstwrite = false;
                } else {
                    YamlEmitter.this.writer.write("\n" + this.indentationString(YamlEmitter.this.indent) + tag + ": ");
                }
                YamlEmitter.this.writer.flush();
            }

            @Override
            protected String indentationString(int indent) {
                if (this.firstwrite) {
                    return super.indentationString(indent);
                }
                return "  " + super.indentationString(indent);
            }
        };
    }

    public void writeTag(String tag) throws IOException {
        this.writer.write("\n" + this.indentationString(this.indent) + tag + ": ");
        this.writer.flush();
    }

    protected String indentationString(int indent) {
        return new String(new char[indent * 4]).replace("\u0000", " ");
    }

    private void writeNaked(String tag) throws IOException {
        this.writer.write(tag);
        this.writer.flush();
    }

    private void writeQuoted(String value) throws IOException {
        boolean escapeChar;
        boolean bl = escapeChar = value != null && value.matches(".*?[\"].*");
        if (escapeChar || value.contains("\n")) {
            this.writer.write("|\n");
            this.writer.write(this.indentationString(this.indent + 1));
            Object[] str = value.split("\n");
            this.writer.write(Joiner.on((String)("\n" + this.indentationString(this.indent + 1))).join(str));
        } else if (value.matches(".*?[-*|#{}?&!>':%@`,\\[\\]\"].*")) {
            this.writer.write("\"" + value + "\"");
        } else {
            this.writer.write(value);
        }
        this.writer.flush();
    }

    public void writeValue(SimpleTypeNode<?> node) throws IOException {
        if (node instanceof StringNode) {
            this.writeQuoted(node.getLiteralValue());
        } else {
            this.writeNaked(node.getLiteralValue());
        }
    }

    public void writeObjectValue(String value) throws IOException {
        this.write(value);
    }

    private void write(String s) throws IOException {
        this.writeQuoted(s);
    }

    public void writeSyntaxElement(String s) throws IOException {
        this.writer.write(s);
        this.writer.flush();
    }

    public void writeIndent() throws IOException {
        this.writer.write(this.indentationString(this.indent));
    }
}

