/*
 * Decompiled with CFR 0.152.
 */
package org.raml.simpleemitter.handlers;

import java.io.IOException;
import org.raml.simpleemitter.HandlerList;
import org.raml.simpleemitter.NodeHandler;
import org.raml.simpleemitter.YamlEmitter;
import org.raml.yagi.framework.nodes.KeyValueNode;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.SimpleTypeNode;

public class KeyValueNodeHandler
extends NodeHandler<KeyValueNode> {
    private final HandlerList handlerList;

    public KeyValueNodeHandler(HandlerList handlerList) {
        this.handlerList = handlerList;
    }

    @Override
    public boolean handles(Node node) {
        return node instanceof KeyValueNode;
    }

    @Override
    public boolean handleSafely(KeyValueNode node, YamlEmitter emitter) throws IOException {
        String scalar = this.isScalar(node.getValue());
        if (scalar != null) {
            emitter.writeTag(node.getKey().toString());
            this.handlerList.handle(node.getValue(), emitter);
        } else {
            emitter.writeTag(node.getKey().toString());
            this.handlerList.handle(node.getValue(), emitter.indent());
        }
        return true;
    }

    private String isScalar(Node node) {
        if (node instanceof SimpleTypeNode) {
            return ((SimpleTypeNode)node).getLiteralValue();
        }
        return null;
    }
}

