/*
 * Decompiled with CFR 0.152.
 */
package org.raml.simpleemitter;

import com.google.common.base.Optional;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import org.raml.simpleemitter.NodeHandler;
import org.raml.simpleemitter.YamlEmitter;
import org.raml.simpleemitter.handlers.ArrayNodeHandler;
import org.raml.simpleemitter.handlers.DefaultNodeHandler;
import org.raml.simpleemitter.handlers.KeyValueNodeHandler;
import org.raml.simpleemitter.handlers.NullNodeHandler;
import org.raml.simpleemitter.handlers.ObjectNodeHandler;
import org.raml.simpleemitter.handlers.ReferenceNodeHandler;
import org.raml.simpleemitter.handlers.SimpleTypeNodeHandler;
import org.raml.simpleemitter.handlers.TypeExpressionNodeHandler;
import org.raml.yagi.framework.nodes.Node;

public class HandlerList
extends NodeHandler<Node> {
    private final List<NodeHandler<? extends Node>> handlerList;

    public HandlerList(List<NodeHandler<? extends Node>> handlers) {
        this.handlerList = handlers;
    }

    public HandlerList() {
        this.handlerList = new ArrayList<NodeHandler<? extends Node>>();
        this.handlerList.add(new TypeExpressionNodeHandler(this));
        this.handlerList.add(new SimpleTypeNodeHandler());
        this.handlerList.add(new KeyValueNodeHandler(this));
        this.handlerList.add(new ObjectNodeHandler(this));
        this.handlerList.add(new ArrayNodeHandler(this));
        this.handlerList.add(new NullNodeHandler());
        this.handlerList.add(new ReferenceNodeHandler());
        this.handlerList.add(new DefaultNodeHandler());
    }

    @Override
    public boolean handles(final Node node) {
        return FluentIterable.from(this.handlerList).anyMatch((Predicate)new Predicate<NodeHandler<? extends Node>>(){

            public boolean apply(@Nullable NodeHandler<? extends Node> nodeHandler) {
                return nodeHandler.handles(node);
            }
        });
    }

    @Override
    public boolean handleSafely(final Node node, YamlEmitter emitter) throws IOException {
        Optional handler = FluentIterable.from(this.handlerList).firstMatch((Predicate)new Predicate<NodeHandler<? extends Node>>(){

            public boolean apply(@Nullable NodeHandler<? extends Node> nodeHandler) {
                return nodeHandler.handles(node);
            }
        });
        return handler.isPresent() && ((NodeHandler)handler.get()).handle(node, emitter);
    }
}

