/*
 * Decompiled with CFR 0.152.
 */
package org.raml.simpleemitter;

import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Arrays;
import java.util.List;
import org.raml.simpleemitter.HandlerList;
import org.raml.simpleemitter.TopNodeComparator;
import org.raml.simpleemitter.YamlEmitter;
import org.raml.v2.api.model.v10.api.Api;
import org.raml.yagi.framework.model.NodeModel;
import org.raml.yagi.framework.nodes.Node;

public class Emitter {
    private final HandlerList list;

    public Emitter(HandlerList list) {
        this.list = list;
    }

    public Emitter() {
        this.list = new HandlerList();
    }

    public void emit(Api api) throws IOException {
        this.emit(api, new OutputStreamWriter(System.out));
    }

    public void emit(Api api, Writer w) throws IOException {
        w.write("#%RAML 1.0");
        NodeModel model = (NodeModel)api;
        Node node = model.getNode();
        for (Node o : this.sortTop(node.getChildren())) {
            this.list.handle(o, this.createEmitter(w));
        }
    }

    private Node[] sortTop(List<Node> children) {
        Node[] nodes = children.toArray(new Node[0]);
        Arrays.sort(nodes, new TopNodeComparator());
        return nodes;
    }

    protected YamlEmitter createEmitter(Writer w) {
        return new YamlEmitter(w, 0);
    }
}

