/*
 * Decompiled with CFR 0.152.
 */
package org.raml.simpleemitter.handlers;

import java.io.IOException;
import java.util.Collections;
import org.raml.simpleemitter.HandlerList;
import org.raml.simpleemitter.YamlEmitter;
import org.raml.simpleemitter.handlers.SubclassedNodeHandler;
import org.raml.simpleemitter.handlers.TypeDeclarationNodeHandler;
import org.raml.yagi.framework.nodes.Node;
import org.raml.yagi.framework.nodes.ObjectNode;
import org.raml.yagi.framework.nodes.SimpleTypeNode;

public class ObjectNodeHandler
extends SubclassedNodeHandler<ObjectNode> {
    private final HandlerList handlerList;

    public ObjectNodeHandler(HandlerList handlerList) {
        super(ObjectNode.class, new HandlerList(Collections.singletonList(new TypeDeclarationNodeHandler(handlerList))));
        this.handlerList = handlerList;
    }

    @Override
    public boolean handleSafely(ObjectNode node, YamlEmitter emitter) throws IOException {
        for (Node child : node.getChildren()) {
            String scalar = this.isScalar((Node)node.getChildren().get(0));
            if (scalar != null) {
                emitter.writeObjectValue(scalar);
                continue;
            }
            this.handlerList.handle(child, emitter);
        }
        return true;
    }

    private String isScalar(Node node) {
        if (node instanceof SimpleTypeNode) {
            return ((SimpleTypeNode)node).getLiteralValue();
        }
        return null;
    }
}

