/*
 * Decompiled with CFR 0.152.
 */
package org.raml.jaxrs.codegen.maven;

import java.io.File;
import java.io.IOException;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.jsonschema2pojo.AnnotationStyle;
import org.raml.jaxrs.generator.Configuration;
import org.raml.jaxrs.generator.RamlScanner;
import org.raml.jaxrs.generator.builders.extensions.resources.TrialResourceClassExtension;
import org.raml.jaxrs.generator.extension.types.LegacyTypeExtension;
import org.raml.jaxrs.generator.extension.types.TypeExtension;

@Mojo(name="generate", requiresProject=true, threadSafe=false, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, defaultPhase=LifecyclePhase.GENERATE_SOURCES)
public class RamlJaxrsCodegenMojo
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    private MavenProject project;
    @Parameter(property="skip", defaultValue="false")
    private boolean skip;
    @Parameter(property="outputDirectory", defaultValue="${project.build.directory}/generated-sources/raml-jaxrs")
    private File outputDirectory;
    @Parameter(property="ramlFile", required=true)
    private File ramlFile;
    @Parameter(property="resourcePackage", required=true)
    private String resourcePackage;
    @Parameter(property="modelPackage")
    private String modelPackage;
    @Parameter(property="supportPackage")
    private String supportPackage;
    @Parameter(property="removeOldOutput", defaultValue="false")
    private boolean removeOldOutput;
    @Parameter(property="generateTypesWith")
    private String[] generateTypesWith;
    @Parameter(property="jsonMapper", defaultValue="jackson2")
    private String jsonMapper;
    @Parameter(property="jsonMapperConfiguration")
    private Map<String, String> jsonMapperConfiguration;
    @Parameter(property="resourceCreationExtension")
    private String resourceCreationExtension;
    @Parameter(property="resourceCreationExtension")
    private String resourceFinishExtension;
    @Parameter(property="typeExtensions")
    private String[] typeExtensions;

    public void execute() throws MojoExecutionException, MojoFailureException {
        if (this.skip) {
            this.getLog().info((CharSequence)"Skipping execution...");
            return;
        }
        if (this.ramlFile == null) {
            throw new MojoExecutionException("ramlFile is not defined");
        }
        try {
            FileUtils.forceMkdir((File)this.outputDirectory);
        }
        catch (IOException ioe) {
            throw new MojoExecutionException("Failed to create directory: " + this.outputDirectory, (Exception)ioe);
        }
        if (this.removeOldOutput) {
            try {
                FileUtils.cleanDirectory((File)this.outputDirectory);
            }
            catch (IOException ioe) {
                throw new MojoExecutionException("Failed to clean directory: " + this.outputDirectory, (Exception)ioe);
            }
        }
        Configuration configuration = new Configuration();
        try {
            String[] c;
            configuration.setModelPackage(this.modelPackage);
            configuration.setResourcePackage(this.resourcePackage);
            configuration.setSupportPackage(this.supportPackage);
            configuration.setOutputDirectory(this.outputDirectory);
            configuration.setJsonMapper(AnnotationStyle.valueOf((String)this.jsonMapper.toUpperCase()));
            configuration.setJsonMapperConfiguration(this.jsonMapperConfiguration);
            configuration.setTypeConfiguration(this.generateTypesWith);
            if (this.resourceCreationExtension != null) {
                c = Class.forName(this.resourceCreationExtension);
                configuration.defaultResourceCreationExtension(c);
            }
            if (this.resourceFinishExtension != null) {
                c = Class.forName(this.resourceCreationExtension);
                configuration.defaultResourceFinishExtension((Class)c);
            }
            if (this.typeExtensions != null) {
                for (String className : this.typeExtensions) {
                    Class<?> c2 = Class.forName(className);
                    if (c2 == null) {
                        throw new MojoExecutionException("typeExtension " + className + " cannot be loaded." + "Have you installed the correct dependency in the plugin configuration?");
                    }
                    if (!(c2.newInstance() instanceof TypeExtension)) {
                        throw new MojoExecutionException("typeExtension " + className + " does not implement" + TrialResourceClassExtension.class.getPackage() + "." + TrialResourceClassExtension.class.getName());
                    }
                    configuration.getTypeExtensions().add((LegacyTypeExtension)c2.newInstance());
                }
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Failed to configure plug-in", e);
        }
        this.project.addCompileSourceRoot(this.outputDirectory.getPath());
        Object currentSourcePath = null;
        try {
            RamlScanner scanner = new RamlScanner(configuration);
            scanner.handle(this.ramlFile);
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error generating Java classes from: " + currentSourcePath, e);
        }
    }
}

