package foo.foo;

import com.fasterxml.jackson.annotation.JsonAnyGetter;
import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Map;
import java.util.regex.Pattern;

@JsonInclude(JsonInclude.Include.NON_NULL)
@JsonTypeName("myOwnValue")
@JsonPropertyOrder("name")
public class AddPropsVerificationImpl implements AddPropsVerification {
  @JsonProperty("name")
  private String name;

  @JsonIgnore
  private Map<String, Object> additionalProperties = new ExcludingMap() {
     {
      addAcceptedPattern(Pattern.compile("name"));
      addAcceptedPattern(Pattern.compile("note\\d+"));
    }
  }
  ;

  @JsonProperty("name")
  public String getName() {
    return this.name;
  }

  @JsonProperty("name")
  public void setName(String name) {
    this.name = name;
  }

  @JsonAnyGetter
  public Map<String, Object> getAdditionalProperties() {
    return additionalProperties;
  }

  @JsonAnySetter
  public void setAdditionalProperties(String key, Object value) {
    this.additionalProperties.put(key, value);
  }
}
